/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.object.debug;

import com.oracle.truffle.api.nodes.GraphPrintVisitor;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.object.DebugShapeVisitor;
import com.oracle.truffle.object.ShapeImpl;
import com.oracle.truffle.object.Transition;
import java.util.Map;

public class IGVShapeVisitor
extends DebugShapeVisitor<IGVShapeVisitor> {
    private final GraphPrintVisitor graphPrinter;

    public IGVShapeVisitor(GraphPrintVisitor printer) {
        this.graphPrinter = printer;
    }

    @Override
    public IGVShapeVisitor visitShape(Shape shape, final Map<? extends Transition, ? extends Shape> transitions) {
        this.graphPrinter.visit(shape, new GraphPrintVisitor.GraphPrintHandler(){

            @Override
            public void visit(Object node, GraphPrintVisitor.GraphPrintAdapter printer) {
                if (!printer.visited(node)) {
                    Shape s = (Shape)node;
                    printer.createElementForNode(s);
                    String name = s.getLastProperty() == null ? "ROOT" : s.getLastProperty().toString();
                    printer.setNodeProperty(s, "name", name);
                    printer.setNodeProperty(s, "valid", s.isValid());
                    printer.setNodeProperty(s, "identityHashCode", Integer.toHexString(System.identityHashCode(s)));
                    printer.setNodeProperty(s, "objectType", s.getObjectType());
                    for (Map.Entry entry : transitions.entrySet()) {
                        Shape dst = (Shape)entry.getValue();
                        ((ShapeImpl)dst).accept(IGVShapeVisitor.this);
                        assert (printer.visited(dst));
                        printer.connectNodes(s, dst, ((Transition)entry.getKey()).toString());
                    }
                }
            }
        });
        return this;
    }
}

