/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle;

import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.vm.PolyglotEngine;
import java.io.IOException;
import org.jruby.JRubyTruffleInterface;
import org.jruby.Ruby;
import org.jruby.ast.RootNode;
import org.jruby.exceptions.MainExitException;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.interop.JRubyContextWrapper;
import org.jruby.truffle.language.control.ExitException;
import org.jruby.truffle.platform.graal.Graal;
import org.jruby.util.cli.Options;

public class JRubyTruffleImpl
implements JRubyTruffleInterface {
    private final PolyglotEngine engine;
    private final RubyContext context;

    public JRubyTruffleImpl(Ruby runtime) {
        this.engine = PolyglotEngine.newBuilder().globalSymbol("org.jruby.truffle.runtime", new JRubyContextWrapper(runtime)).build();
        try {
            this.context = (RubyContext)this.engine.eval(Source.fromText("Truffle::Boot.context", "context").withMimeType("application/x-ruby")).get();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Object execute(RootNode rootNode) {
        if (!Graal.isGraal() && ((Boolean)Options.TRUFFLE_GRAAL_WARNING_UNLESS.load()).booleanValue()) {
            System.err.println("WARNING: This JVM does not have the Graal compiler. JRuby+Truffle's performance without it will be limited. See https://github.com/jruby/jruby/wiki/Truffle-FAQ#how-do-i-get-jrubytruffle");
        }
        this.context.getJRubyInterop().setOriginalInputFile(rootNode.getPosition().getFile());
        try {
            return this.engine.eval(Source.fromText("Truffle::Boot.run_jruby_root", "run_jruby_root").withMimeType("application/x-ruby")).get();
        }
        catch (IOException e) {
            if (e.getCause() instanceof ExitException) {
                ExitException exit = (ExitException)e.getCause();
                throw new MainExitException(exit.getCode());
            }
            throw new RuntimeException(e);
        }
    }

    public void dispose() {
        this.engine.dispose();
    }
}

