/*
 * Decompiled with CFR 0.152.
 */
package org.encog.mathutil.error;

import org.encog.mathutil.error.ErrorCalculationMode;

public class ErrorCalculation {
    private static ErrorCalculationMode mode = ErrorCalculationMode.MSE;
    private double globalError;
    private int setSize;

    public static ErrorCalculationMode getMode() {
        return mode;
    }

    public static void setMode(ErrorCalculationMode theMode) {
        mode = theMode;
    }

    public final double calculate() {
        if (this.setSize == 0) {
            return 0.0;
        }
        switch (ErrorCalculation.getMode()) {
            case RMS: {
                return this.calculateRMS();
            }
            case MSE: {
                return this.calculateMSE();
            }
            case ESS: {
                return this.calculateESS();
            }
        }
        return this.calculateMSE();
    }

    public final double calculateMSE() {
        if (this.setSize == 0) {
            return 0.0;
        }
        double err = this.globalError / (double)this.setSize;
        return err;
    }

    public final double calculateESS() {
        if (this.setSize == 0) {
            return 0.0;
        }
        double err = this.globalError / 2.0;
        return err;
    }

    public final double calculateRMS() {
        if (this.setSize == 0) {
            return 0.0;
        }
        double err = Math.sqrt(this.globalError / (double)this.setSize);
        return err;
    }

    public final void reset() {
        this.globalError = 0.0;
        this.setSize = 0;
    }

    public final void updateError(double actual, double ideal) {
        double delta = ideal - actual;
        this.globalError += delta * delta;
        ++this.setSize;
    }

    public final void updateError(double[] actual, double[] ideal, double significance) {
        for (int i = 0; i < actual.length; ++i) {
            double delta = (ideal[i] - actual[i]) * significance;
            this.globalError += delta * delta;
        }
        this.setSize += ideal.length;
    }
}

