/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.swing;

import com.eteks.sweethome3d.j3d.Component3DManager;
import com.eteks.sweethome3d.model.AspectRatio;
import com.eteks.sweethome3d.model.Home;
import com.eteks.sweethome3d.model.UserPreferences;
import com.eteks.sweethome3d.swing.AutoCommitSpinner;
import com.eteks.sweethome3d.swing.SwingTools;
import com.eteks.sweethome3d.tools.OperatingSystem;
import com.eteks.sweethome3d.tools.ResourceURLContent;
import com.eteks.sweethome3d.viewcontroller.AbstractPhotoController;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.Locale;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.KeyStroke;
import javax.swing.SpinnerNumberModel;
import javax.swing.ToolTipManager;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class PhotoSizeAndQualityPanel
extends JPanel {
    private JLabel widthLabel;
    private JSpinner widthSpinner;
    private JLabel heightLabel;
    private JSpinner heightSpinner;
    private JCheckBox applyProportionsCheckBox;
    private JComboBox aspectRatioComboBox;
    private JLabel qualityLabel;
    private JSlider qualitySlider;
    private JLabel fastQualityLabel;
    private JLabel bestQualityLabel;

    public PhotoSizeAndQualityPanel(Home home, UserPreferences userPreferences, AbstractPhotoController abstractPhotoController) {
        super(new GridBagLayout());
        this.createComponents(home, userPreferences, abstractPhotoController);
        this.setMnemonics(userPreferences);
        this.layoutComponents();
        userPreferences.addPropertyChangeListener(UserPreferences.Property.LANGUAGE, new LanguageChangeListener(this));
    }

    private void createComponents(Home home, final UserPreferences userPreferences, final AbstractPhotoController abstractPhotoController) {
        this.widthLabel = new JLabel();
        final SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(480, 10, 10000, 10);
        this.widthSpinner = new AutoCommitSpinner(spinnerNumberModel);
        spinnerNumberModel.setValue(abstractPhotoController.getWidth());
        spinnerNumberModel.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                abstractPhotoController.setWidth(((Number)spinnerNumberModel.getValue()).intValue());
            }
        });
        abstractPhotoController.addPropertyChangeListener(AbstractPhotoController.Property.WIDTH, new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                spinnerNumberModel.setValue(abstractPhotoController.getWidth());
            }
        });
        this.heightLabel = new JLabel();
        final SpinnerNumberModel spinnerNumberModel2 = new SpinnerNumberModel(480, 10, 10000, 10);
        this.heightSpinner = new AutoCommitSpinner(spinnerNumberModel2);
        spinnerNumberModel2.setValue(abstractPhotoController.getHeight());
        spinnerNumberModel2.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                abstractPhotoController.setHeight(((Number)spinnerNumberModel2.getValue()).intValue());
            }
        });
        abstractPhotoController.addPropertyChangeListener(AbstractPhotoController.Property.HEIGHT, new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                spinnerNumberModel2.setValue(abstractPhotoController.getHeight());
            }
        });
        boolean bl = abstractPhotoController.getAspectRatio() != AspectRatio.FREE_RATIO;
        this.applyProportionsCheckBox = new JCheckBox();
        this.applyProportionsCheckBox.setSelected(bl);
        this.applyProportionsCheckBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                abstractPhotoController.setAspectRatio(PhotoSizeAndQualityPanel.this.applyProportionsCheckBox.isSelected() ? (AspectRatio)((Object)PhotoSizeAndQualityPanel.this.aspectRatioComboBox.getSelectedItem()) : AspectRatio.FREE_RATIO);
            }
        });
        this.aspectRatioComboBox = new JComboBox<Object>(new Object[]{AspectRatio.VIEW_3D_RATIO, AspectRatio.SQUARE_RATIO, AspectRatio.RATIO_4_3, AspectRatio.RATIO_3_2, AspectRatio.RATIO_16_9, AspectRatio.RATIO_2_1});
        this.aspectRatioComboBox.setRenderer(new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                AspectRatio aspectRatio = (AspectRatio)((Object)object);
                String string = "";
                if (aspectRatio != AspectRatio.FREE_RATIO) {
                    switch (aspectRatio) {
                        case VIEW_3D_RATIO: {
                            string = userPreferences.getLocalizedString(PhotoSizeAndQualityPanel.class, "aspectRatioComboBox.view3DRatio.text", new Object[0]);
                            break;
                        }
                        case SQUARE_RATIO: {
                            string = userPreferences.getLocalizedString(PhotoSizeAndQualityPanel.class, "aspectRatioComboBox.squareRatio.text", new Object[0]);
                            break;
                        }
                        case RATIO_4_3: {
                            string = "4/3";
                            break;
                        }
                        case RATIO_3_2: {
                            string = "3/2";
                            break;
                        }
                        case RATIO_16_9: {
                            string = "16/9";
                            break;
                        }
                        case RATIO_2_1: {
                            string = "2/1";
                        }
                    }
                }
                return super.getListCellRendererComponent((JList<?>)jList, string, n, bl, bl2);
            }
        });
        this.aspectRatioComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                abstractPhotoController.setAspectRatio((AspectRatio)((Object)PhotoSizeAndQualityPanel.this.aspectRatioComboBox.getSelectedItem()));
            }
        });
        this.aspectRatioComboBox.setEnabled(bl);
        this.aspectRatioComboBox.setSelectedItem((Object)abstractPhotoController.getAspectRatio());
        abstractPhotoController.addPropertyChangeListener(AbstractPhotoController.Property.ASPECT_RATIO, new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                boolean bl = abstractPhotoController.getAspectRatio() != AspectRatio.FREE_RATIO;
                PhotoSizeAndQualityPanel.this.applyProportionsCheckBox.setSelected(bl);
                PhotoSizeAndQualityPanel.this.aspectRatioComboBox.setEnabled(bl);
                PhotoSizeAndQualityPanel.this.aspectRatioComboBox.setSelectedItem((Object)abstractPhotoController.getAspectRatio());
            }
        });
        this.qualityLabel = new JLabel();
        this.fastQualityLabel = new JLabel();
        this.bestQualityLabel = new JLabel();
        this.qualitySlider = new JSlider(1, abstractPhotoController.getQualityLevelCount()){

            public String getToolTipText(MouseEvent mouseEvent) {
                float f = PhotoSizeAndQualityPanel.this.getSliderValueAt(this, mouseEvent.getX(), userPreferences);
                float f2 = f - (float)Math.floor(f);
                if (f2 < 0.25f || f2 > 0.75f) {
                    return "<html><table><tr valign='middle'><td><img border='1' src='" + new ResourceURLContent(PhotoSizeAndQualityPanel.class, "resources/quality" + Math.round(f - (float)PhotoSizeAndQualityPanel.this.qualitySlider.getMinimum()) + ".jpg").getURL() + "'></td>" + "<td>" + userPreferences.getLocalizedString(PhotoSizeAndQualityPanel.class, "quality" + Math.round(f - (float)PhotoSizeAndQualityPanel.this.qualitySlider.getMinimum()) + "DescriptionLabel.text", new Object[0]) + "</td>" + "</tr></table>";
                }
                return null;
            }
        };
        this.qualitySlider.addMouseListener(new MouseAdapter(){

            public void mousePressed(final MouseEvent mouseEvent) {
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        float f = PhotoSizeAndQualityPanel.this.getSliderValueAt(PhotoSizeAndQualityPanel.this.qualitySlider, mouseEvent.getX(), userPreferences);
                        if (PhotoSizeAndQualityPanel.this.qualitySlider.getValue() == Math.round(f)) {
                            ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
                            int n = toolTipManager.getInitialDelay();
                            toolTipManager.setInitialDelay(Math.min(n, 150));
                            toolTipManager.mouseMoved(mouseEvent);
                            toolTipManager.setInitialDelay(n);
                        }
                    }
                });
            }
        });
        this.qualitySlider.setPaintTicks(true);
        this.qualitySlider.setMajorTickSpacing(1);
        this.qualitySlider.setSnapToTicks(true);
        final boolean bl2 = Component3DManager.getInstance().isOffScreenImageSupported();
        this.qualitySlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                if (!bl2) {
                    PhotoSizeAndQualityPanel.this.qualitySlider.setValue(Math.max(PhotoSizeAndQualityPanel.this.qualitySlider.getMinimum() + 2, PhotoSizeAndQualityPanel.this.qualitySlider.getValue()));
                }
                abstractPhotoController.setQuality(PhotoSizeAndQualityPanel.this.qualitySlider.getValue() - PhotoSizeAndQualityPanel.this.qualitySlider.getMinimum());
            }
        });
        abstractPhotoController.addPropertyChangeListener(AbstractPhotoController.Property.QUALITY, new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                PhotoSizeAndQualityPanel.this.qualitySlider.setValue(PhotoSizeAndQualityPanel.this.qualitySlider.getMinimum() + abstractPhotoController.getQuality());
            }
        });
        this.qualitySlider.setValue(this.qualitySlider.getMinimum() + abstractPhotoController.getQuality());
        final JComponent jComponent = (JComponent)((Object)abstractPhotoController.get3DView());
        final ComponentAdapter componentAdapter = new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                abstractPhotoController.set3DViewAspectRatio((float)jComponent.getWidth() / (float)jComponent.getHeight());
            }
        };
        this.addAncestorListener(new AncestorListener(){

            public void ancestorAdded(AncestorEvent ancestorEvent) {
                jComponent.addComponentListener(componentAdapter);
                ToolTipManager.sharedInstance().registerComponent(PhotoSizeAndQualityPanel.this.qualitySlider);
            }

            public void ancestorRemoved(AncestorEvent ancestorEvent) {
                ToolTipManager.sharedInstance().unregisterComponent(PhotoSizeAndQualityPanel.this.qualitySlider);
                jComponent.removeComponentListener(componentAdapter);
            }

            public void ancestorMoved(AncestorEvent ancestorEvent) {
            }
        });
        this.setComponentTexts(userPreferences);
    }

    private float getSliderValueAt(JSlider jSlider, int n, UserPreferences userPreferences) {
        int n2 = 0;
        int n3 = 0;
        int n4 = jSlider.getWidth() - n2 - n3;
        return (float)jSlider.getMinimum() + (float)(n - (jSlider.getComponentOrientation().isLeftToRight() ? n2 : n3)) / (float)n4 * (float)(jSlider.getMaximum() - jSlider.getMinimum());
    }

    private void setComponentTexts(UserPreferences userPreferences) {
        this.widthLabel.setText(SwingTools.getLocalizedLabelText(userPreferences, PhotoSizeAndQualityPanel.class, "widthLabel.text", new Object[0]));
        this.heightLabel.setText(SwingTools.getLocalizedLabelText(userPreferences, PhotoSizeAndQualityPanel.class, "heightLabel.text", new Object[0]));
        this.applyProportionsCheckBox.setText(SwingTools.getLocalizedLabelText(userPreferences, PhotoSizeAndQualityPanel.class, "applyProportionsCheckBox.text", new Object[0]));
        this.qualityLabel.setText(SwingTools.getLocalizedLabelText(userPreferences, PhotoSizeAndQualityPanel.class, "qualityLabel.text", new Object[0]));
        this.fastQualityLabel.setText(SwingTools.getLocalizedLabelText(userPreferences, PhotoSizeAndQualityPanel.class, "fastLabel.text", new Object[0]));
        if (!Component3DManager.getInstance().isOffScreenImageSupported()) {
            this.fastQualityLabel.setEnabled(false);
        }
        this.bestQualityLabel.setText(SwingTools.getLocalizedLabelText(userPreferences, PhotoSizeAndQualityPanel.class, "bestLabel.text", new Object[0]));
    }

    private void setMnemonics(UserPreferences userPreferences) {
        if (!OperatingSystem.isMacOSX()) {
            this.widthLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(PhotoSizeAndQualityPanel.class, "widthLabel.mnemonic", new Object[0])).getKeyCode());
            this.widthLabel.setLabelFor(this.widthSpinner);
            this.heightLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(PhotoSizeAndQualityPanel.class, "heightLabel.mnemonic", new Object[0])).getKeyCode());
            this.heightLabel.setLabelFor(this.heightSpinner);
            this.applyProportionsCheckBox.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(PhotoSizeAndQualityPanel.class, "applyProportionsCheckBox.mnemonic", new Object[0])).getKeyCode());
            this.qualityLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(PhotoSizeAndQualityPanel.class, "qualityLabel.mnemonic", new Object[0])).getKeyCode());
            this.qualityLabel.setLabelFor(this.qualitySlider);
        }
    }

    private void layoutComponents() {
        int n = OperatingSystem.isMacOSX() ? 11 : 10;
        Insets insets = new Insets(0, 0, 0, 5);
        this.add((Component)this.widthLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, insets, 0, 0));
        this.widthLabel.setHorizontalAlignment(n);
        Insets insets2 = new Insets(0, 0, 0, 10);
        this.add((Component)this.widthSpinner, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 21, 2, insets2, 0, 0));
        this.add((Component)this.heightLabel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 2, insets, 0, 0));
        this.heightLabel.setHorizontalAlignment(n);
        this.add((Component)this.heightSpinner, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 21, 2, new Insets(0, 0, 0, 0), 0, 0));
        JPanel jPanel = new JPanel();
        jPanel.add(this.applyProportionsCheckBox);
        jPanel.add(this.aspectRatioComboBox);
        this.add((Component)jPanel, new GridBagConstraints(0, 1, 4, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.qualityLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 5), 0, 0));
        this.qualityLabel.setHorizontalAlignment(n);
        this.add((Component)this.qualitySlider, new GridBagConstraints(1, 3, 3, 1, 0.0, 0.0, 21, 2, new Insets(0, 0, 0, 0), 0, 0));
        JPanel jPanel2 = new JPanel(new BorderLayout(20, 0));
        jPanel2.add((Component)this.fastQualityLabel, "West");
        jPanel2.add((Component)this.bestQualityLabel, "East");
        this.add((Component)jPanel2, new GridBagConstraints(1, 4, 3, 1, 0.0, 0.0, 10, 2, new Insets(OperatingSystem.isWindows() ? 0 : -3, 0, 0, 0), 0, 0));
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.widthSpinner.setEnabled(bl);
        this.heightSpinner.setEnabled(bl);
        this.applyProportionsCheckBox.setEnabled(bl);
        this.aspectRatioComboBox.setEnabled(bl);
        this.qualitySlider.setEnabled(bl);
    }

    public void setProportionsChoiceEnabled(boolean bl) {
        this.applyProportionsCheckBox.setEnabled(bl);
        this.aspectRatioComboBox.setEnabled(bl && this.applyProportionsCheckBox.isSelected());
    }

    public static class LanguageChangeListener
    implements PropertyChangeListener {
        private final WeakReference<PhotoSizeAndQualityPanel> photoPanel;

        public LanguageChangeListener(PhotoSizeAndQualityPanel photoSizeAndQualityPanel) {
            this.photoPanel = new WeakReference<PhotoSizeAndQualityPanel>(photoSizeAndQualityPanel);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            PhotoSizeAndQualityPanel photoSizeAndQualityPanel = (PhotoSizeAndQualityPanel)this.photoPanel.get();
            UserPreferences userPreferences = (UserPreferences)propertyChangeEvent.getSource();
            if (photoSizeAndQualityPanel == null) {
                userPreferences.removePropertyChangeListener(UserPreferences.Property.LANGUAGE, this);
            } else {
                photoSizeAndQualityPanel.setComponentOrientation(ComponentOrientation.getOrientation(Locale.getDefault()));
                photoSizeAndQualityPanel.setComponentTexts(userPreferences);
                photoSizeAndQualityPanel.setMnemonics(userPreferences);
            }
        }
    }
}

