/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.element.elementnew.uml;

import com.baselet.control.basics.geom.PointDouble;
import com.baselet.control.basics.geom.Rectangle;
import com.baselet.control.enums.ElementId;
import com.baselet.diagram.draw.DrawHandler;
import com.baselet.element.NewGridElement;
import com.baselet.element.facet.PropertiesParserState;
import com.baselet.element.facet.Settings;
import com.baselet.element.settings.SettingsAutoresize;
import com.baselet.element.sticking.StickingPolygon;
import com.baselet.element.sticking.polygon.StickingPolygonGenerator;
import java.util.Arrays;

public class Timer
extends NewGridElement {
    private static final int CLOCK_DIM = 40;
    private final StickingPolygonGenerator timerStickingPolygonGenerator = new StickingPolygonGenerator(){

        @Override
        public StickingPolygon generateStickingBorder(Rectangle rect) {
            StickingPolygon p = new StickingPolygon(rect.x, rect.y);
            p.addPoint(Timer.this.xClock(), 0.0);
            p.addPoint(Timer.this.x2Clock(), 40.0);
            p.addPoint(Timer.this.xClock(), 40.0);
            p.addPoint(Timer.this.x2Clock(), 0, true);
            return p;
        }
    };

    @Override
    public ElementId getId() {
        return ElementId.UMLTimer;
    }

    @Override
    protected void drawCommonContent(PropertiesParserState state) {
        DrawHandler drawer = state.getDrawer();
        state.updateMinimumSize(40.0, 40.0);
        drawer.drawLines(Arrays.asList(new PointDouble(this.xClock(), 0.0), new PointDouble(this.x2Clock(), 40.0), new PointDouble(this.xClock(), 40.0), new PointDouble(this.x2Clock(), 0.0), new PointDouble(this.xClock(), 0.0)));
        state.setStickingPolygonGenerator(this.timerStickingPolygonGenerator);
    }

    private int x2Clock() {
        return this.xClock() + 40;
    }

    private int xClock() {
        return (this.getRealSize().width - 40) / 2;
    }

    @Override
    protected Settings createSettings() {
        return new SettingsAutoresize();
    }
}

