/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.view;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration.FileConfiguration;
import org.parosproxy.paros.model.Model;
import org.zaproxy.zap.extension.httppanel.HttpPanel;
import org.zaproxy.zap.extension.httppanel.component.HttpPanelComponentInterface;
import org.zaproxy.zap.extension.httppanel.view.HttpPanelDefaultViewSelector;
import org.zaproxy.zap.extension.httppanel.view.HttpPanelView;

public class HttpPanelManager {
    private static HttpPanelManager instance = null;
    private HttpPanelManagement requestPanels = new HttpPanelManagement();
    private HttpPanelManagement responsePanels = new HttpPanelManagement();

    private HttpPanelManager() {
    }

    public static HttpPanelManager getInstance() {
        if (instance == null) {
            HttpPanelManager.createInstance();
        }
        return instance;
    }

    private static synchronized void createInstance() {
        if (instance == null) {
            instance = new HttpPanelManager();
        }
    }

    public void addRequestPanel(HttpPanel httpPanel) {
        this.requestPanels.addPanel(httpPanel);
    }

    public void addRequestComponentFactory(HttpPanelComponentFactory httpPanelComponentFactory) {
        this.requestPanels.addComponentFactory(httpPanelComponentFactory);
    }

    public void addRequestViewFactory(String string, HttpPanelViewFactory httpPanelViewFactory) {
        this.requestPanels.addViewFactory(string, httpPanelViewFactory);
    }

    public void addRequestDefaultViewSelectorFactory(String string, HttpPanelDefaultViewSelectorFactory httpPanelDefaultViewSelectorFactory) {
        this.requestPanels.addDefaultViewSelectorFactory(string, httpPanelDefaultViewSelectorFactory);
    }

    public void addResponsePanel(HttpPanel httpPanel) {
        this.responsePanels.addPanel(httpPanel);
    }

    public void addResponseComponentFactory(HttpPanelComponentFactory httpPanelComponentFactory) {
        this.responsePanels.addComponentFactory(httpPanelComponentFactory);
    }

    public void addResponseViewFactory(String string, HttpPanelViewFactory httpPanelViewFactory) {
        this.responsePanels.addViewFactory(string, httpPanelViewFactory);
    }

    public void addResponseDefaultViewSelectorFactory(String string, HttpPanelDefaultViewSelectorFactory httpPanelDefaultViewSelectorFactory) {
        this.responsePanels.addDefaultViewSelectorFactory(string, httpPanelDefaultViewSelectorFactory);
    }

    public void removeRequestPanel(HttpPanel httpPanel) {
        this.requestPanels.removePanel(httpPanel);
    }

    public void removeRequestComponentFactory(String string) {
        this.requestPanels.removeComponentFactory(string);
    }

    public void removeRequestComponents(String string) {
        this.requestPanels.removeComponents(string);
    }

    public void removeRequestViewFactory(String string, String string2) {
        this.requestPanels.removeViewFactory(string, string2);
    }

    public void removeRequestViews(String string, String string2, Object object) {
        this.requestPanels.removeViews(string, string2, object);
    }

    public void removeRequestDefaultViewSelectorFactory(String string, String string2) {
        this.requestPanels.removeDefaultViewSelectorFactory(string, string2);
    }

    public void removeRequestDefaultViewSelectorFactoryAndDefaultViewSelectorsAdded(String string, String string2, Object object) {
        this.requestPanels.removeDefaultViewSelectors(string, string2, object);
    }

    public void removeResponsePanel(HttpPanel httpPanel) {
        this.responsePanels.removePanel(httpPanel);
    }

    public void removeResponseComponentFactory(String string) {
        this.responsePanels.removeComponentFactory(string);
    }

    public void removeResponseComponents(String string) {
        this.responsePanels.removeComponents(string);
    }

    public void removeResponseViewFactory(String string, String string2) {
        this.responsePanels.removeViewFactory(string, string2);
    }

    public void removeResponseViews(String string, String string2, Object object) {
        this.responsePanels.removeViews(string, string2, object);
    }

    public void removeResponseDefaultViewSelectorFactory(String string, String string2) {
        this.responsePanels.removeDefaultViewSelectorFactory(string, string2);
    }

    public void removeResponseDefaultViewSelectors(String string, String string2, Object object) {
        this.responsePanels.removeDefaultViewSelectors(string, string2, object);
    }

    public static interface HttpPanelDefaultViewSelectorFactory {
        public String getName();

        public HttpPanelDefaultViewSelector getNewDefaultViewSelector();

        public Object getOptions();
    }

    public static interface HttpPanelViewFactory {
        public String getName();

        public HttpPanelView getNewView();

        public Object getOptions();
    }

    public static interface HttpPanelComponentFactory {
        public String getName();

        public String getComponentName();

        public HttpPanelComponentInterface getNewComponent();
    }

    private static final class HttpPanelManagement {
        private List<HttpPanel> panels = new ArrayList<HttpPanel>();
        private Map<String, HttpPanelComponentFactory> components = new HashMap<String, HttpPanelComponentFactory>();
        private Map<String, Map<String, HttpPanelViewFactory>> views = new HashMap<String, Map<String, HttpPanelViewFactory>>();
        private Map<String, Map<String, HttpPanelDefaultViewSelectorFactory>> defaultViews = new HashMap<String, Map<String, HttpPanelDefaultViewSelectorFactory>>();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addPanel(HttpPanel httpPanel) {
            HttpPanelManagement httpPanelManagement = this;
            synchronized (httpPanelManagement) {
                this.panels.add(httpPanel);
                FileConfiguration fileConfiguration = Model.getSingleton().getOptionsParam().getConfig();
                for (HttpPanelComponentFactory object : this.components.values()) {
                    httpPanel.addComponent(object.getNewComponent(), fileConfiguration);
                }
                for (Map.Entry entry : this.views.entrySet()) {
                    for (Object object : ((Map)entry.getValue()).values()) {
                        httpPanel.addView((String)entry.getKey(), object.getNewView(), object.getOptions(), fileConfiguration);
                    }
                }
                for (Map.Entry entry : this.defaultViews.entrySet()) {
                    for (Object object : ((Map)entry.getValue()).values()) {
                        httpPanel.addDefaultViewSelector((String)entry.getKey(), object.getNewDefaultViewSelector(), object.getOptions());
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removePanel(HttpPanel httpPanel) {
            HttpPanelManagement httpPanelManagement = this;
            synchronized (httpPanelManagement) {
                this.panels.remove(httpPanel);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addComponentFactory(HttpPanelComponentFactory httpPanelComponentFactory) {
            HttpPanelManagement httpPanelManagement = this;
            synchronized (httpPanelManagement) {
                if (this.components.containsKey(httpPanelComponentFactory.getName())) {
                    return;
                }
                this.components.put(httpPanelComponentFactory.getName(), httpPanelComponentFactory);
                FileConfiguration fileConfiguration = Model.getSingleton().getOptionsParam().getConfig();
                for (HttpPanel httpPanel : this.panels) {
                    Object object;
                    httpPanel.addComponent(httpPanelComponentFactory.getNewComponent(), fileConfiguration);
                    String string = httpPanelComponentFactory.getComponentName();
                    Map<String, HttpPanelViewFactory> map = this.views.get(string);
                    if (map != null) {
                        object = map.values().iterator();
                        while (object.hasNext()) {
                            HttpPanelViewFactory httpPanelViewFactory = (HttpPanelViewFactory)object.next();
                            httpPanel.addView(string, httpPanelViewFactory.getNewView(), httpPanelViewFactory.getOptions(), fileConfiguration);
                        }
                    }
                    if ((object = this.defaultViews.get(string)) == null) continue;
                    for (HttpPanelDefaultViewSelectorFactory httpPanelDefaultViewSelectorFactory : object.values()) {
                        httpPanel.addDefaultViewSelector(string, httpPanelDefaultViewSelectorFactory.getNewDefaultViewSelector(), httpPanelDefaultViewSelectorFactory.getOptions());
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeComponentFactory(String string) {
            HttpPanelManagement httpPanelManagement = this;
            synchronized (httpPanelManagement) {
                this.components.remove(string);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeComponents(String string) {
            HttpPanelManagement httpPanelManagement = this;
            synchronized (httpPanelManagement) {
                for (HttpPanel httpPanel : this.panels) {
                    httpPanel.removeComponent(string);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addViewFactory(String string, HttpPanelViewFactory httpPanelViewFactory) {
            HttpPanelManagement httpPanelManagement = this;
            synchronized (httpPanelManagement) {
                Map<String, HttpPanelViewFactory> map = this.views.get(string);
                if (map == null) {
                    map = new HashMap<String, HttpPanelViewFactory>();
                    this.views.put(string, map);
                } else if (this.views.containsKey(httpPanelViewFactory.getName())) {
                    return;
                }
                map.put(httpPanelViewFactory.getName(), httpPanelViewFactory);
                FileConfiguration fileConfiguration = Model.getSingleton().getOptionsParam().getConfig();
                for (HttpPanel httpPanel : this.panels) {
                    httpPanel.addView(string, httpPanelViewFactory.getNewView(), httpPanelViewFactory.getOptions(), fileConfiguration);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeViewFactory(String string, String string2) {
            HttpPanelManagement httpPanelManagement = this;
            synchronized (httpPanelManagement) {
                Map<String, HttpPanelViewFactory> map = this.views.get(string);
                if (map == null) {
                    return;
                }
                HttpPanelViewFactory httpPanelViewFactory = map.get(string2);
                if (httpPanelViewFactory == null) {
                    return;
                }
                map.remove(string2);
                if (map.isEmpty()) {
                    this.views.put(string, null);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeViews(String string, String string2, Object object) {
            HttpPanelManagement httpPanelManagement = this;
            synchronized (httpPanelManagement) {
                for (HttpPanel httpPanel : this.panels) {
                    httpPanel.removeView(string, string2, object);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addDefaultViewSelectorFactory(String string, HttpPanelDefaultViewSelectorFactory httpPanelDefaultViewSelectorFactory) {
            HttpPanelManagement httpPanelManagement = this;
            synchronized (httpPanelManagement) {
                Map<String, HttpPanelDefaultViewSelectorFactory> map = this.defaultViews.get(string);
                if (map == null) {
                    map = new HashMap<String, HttpPanelDefaultViewSelectorFactory>();
                    this.defaultViews.put(string, map);
                } else if (this.views.containsKey(httpPanelDefaultViewSelectorFactory.getName())) {
                    return;
                }
                map.put(httpPanelDefaultViewSelectorFactory.getName(), httpPanelDefaultViewSelectorFactory);
                for (HttpPanel httpPanel : this.panels) {
                    httpPanel.addDefaultViewSelector(string, httpPanelDefaultViewSelectorFactory.getNewDefaultViewSelector(), httpPanelDefaultViewSelectorFactory.getOptions());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeDefaultViewSelectorFactory(String string, String string2) {
            HttpPanelManagement httpPanelManagement = this;
            synchronized (httpPanelManagement) {
                Map<String, HttpPanelDefaultViewSelectorFactory> map = this.defaultViews.get(string);
                if (map == null) {
                    return;
                }
                HttpPanelDefaultViewSelectorFactory httpPanelDefaultViewSelectorFactory = map.get(string2);
                if (httpPanelDefaultViewSelectorFactory == null) {
                    return;
                }
                map.remove(string2);
                if (map.isEmpty()) {
                    this.defaultViews.put(string, null);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeDefaultViewSelectors(String string, String string2, Object object) {
            HttpPanelManagement httpPanelManagement = this;
            synchronized (httpPanelManagement) {
                for (HttpPanel httpPanel : this.panels) {
                    httpPanel.removeDefaultViewSelector(string, string2, object);
                }
            }
        }
    }
}

