/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.pdf.extensions;

import org.apache.fop.apps.FOPException;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.render.pdf.extensions.PDFCollectionEntryElement;
import org.apache.fop.render.pdf.extensions.PDFCollectionEntryExtension;
import org.apache.fop.render.pdf.extensions.PDFObjectType;
import org.apache.fop.render.pdf.extensions.PDFReferenceExtension;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;

public class PDFReferenceElement
extends PDFCollectionEntryElement {
    public static final String ATT_REFID = "refid";

    PDFReferenceElement(FONode parent) {
        super(parent, PDFObjectType.Reference);
    }

    public void processNode(String elementName, Locator locator, Attributes attlist, PropertyList propertyList) throws FOPException {
        super.processNode(elementName, locator, attlist, propertyList);
        String refid = attlist.getValue(ATT_REFID);
        if (refid == null) {
            this.missingPropertyError(ATT_REFID);
        } else if (refid.length() == 0) {
            this.invalidPropertyValueError(ATT_REFID, refid, null);
        } else {
            PDFCollectionEntryExtension extension = this.getExtension();
            assert (extension instanceof PDFReferenceExtension);
            ((PDFReferenceExtension)extension).setReferenceId(refid);
        }
    }
}

