/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.Collection;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;
import org.openstreetmap.josm.tools.Utils;

public final class CopyAction
extends JosmAction {
    public static final String CLIPBOARD_REGEXP = "((node|way|relation)\\s\\d+,)*(node|way|relation)\\s\\d+";

    public CopyAction() {
        super(I18n.tr("Copy", new Object[0]), "copy", I18n.tr("Copy selected objects to paste buffer.", new Object[0]), Shortcut.registerShortcut("system:copy", I18n.tr("Edit: {0}", I18n.tr("Copy", new Object[0])), 67, 5006), true);
        this.putValue("help", HelpUtil.ht("/Action/Copy"));
        Main.registerActionShortcut(this, Shortcut.registerShortcut("system:copy:cua", I18n.tr("Edit: {0}", I18n.tr("Copy", new Object[0])), 155, 5006));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.isEmptySelection()) {
            return;
        }
        Collection<OsmPrimitive> collection = this.getLayerManager().getEditDataSet().getSelected();
        CopyAction.copy(this.getLayerManager().getEditLayer(), collection);
    }

    public static void copy(OsmDataLayer osmDataLayer, Collection<OsmPrimitive> collection) {
        String string = CopyAction.getCopyString(collection);
        Utils.copyToClipboard(string);
        Main.pasteBuffer.makeCopy(collection);
        Main.pasteSource = osmDataLayer;
    }

    static String getCopyString(Collection<? extends OsmPrimitive> collection) {
        StringBuilder stringBuilder = new StringBuilder();
        for (OsmPrimitive osmPrimitive : collection) {
            stringBuilder.append(OsmPrimitiveType.from(osmPrimitive).getAPIName()).append(' ').append(osmPrimitive.getId()).append(',');
        }
        return stringBuilder.substring(0, stringBuilder.length() - 1);
    }

    @Override
    protected void updateEnabledState() {
        this.updateEnabledStateOnCurrentSelection();
    }

    @Override
    protected void updateEnabledState(Collection<? extends OsmPrimitive> collection) {
        this.setEnabled(collection != null && !collection.isEmpty());
    }

    private boolean isEmptySelection() {
        Collection<OsmPrimitive> collection = this.getLayerManager().getEditDataSet().getSelected();
        if (collection.isEmpty()) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("Please select something to copy.", new Object[0]), I18n.tr("Information", new Object[0]), 1);
            return true;
        }
        return false;
    }
}

