/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.conflict.tags;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.table.DefaultTableModel;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.RelationToChildReference;
import org.openstreetmap.josm.gui.conflict.tags.RelationMemberConflictDecision;
import org.openstreetmap.josm.gui.conflict.tags.RelationMemberConflictDecisionType;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.tools.Predicate;
import org.openstreetmap.josm.tools.Utils;

public class RelationMemberConflictResolverModel
extends DefaultTableModel {
    public static final String NUM_CONFLICTS_PROP = RelationMemberConflictResolverModel.class.getName() + ".numConflicts";
    protected final transient List<RelationMemberConflictDecision> decisions = new ArrayList<RelationMemberConflictDecision>();
    protected transient Collection<Relation> relations;
    protected transient Collection<? extends OsmPrimitive> primitives;
    private int numConflicts;
    private final PropertyChangeSupport support = new PropertyChangeSupport(this);

    public boolean isResolvedCompletely() {
        return this.numConflicts == 0;
    }

    public int getNumConflicts() {
        return this.numConflicts;
    }

    protected void updateNumConflicts() {
        int n = 0;
        for (RelationMemberConflictDecision relationMemberConflictDecision : this.decisions) {
            if (relationMemberConflictDecision.isDecided()) continue;
            ++n;
        }
        int n2 = this.numConflicts;
        this.numConflicts = n;
        if (this.numConflicts != n2) {
            this.support.firePropertyChange(this.getProperty(), n2, this.numConflicts);
        }
    }

    protected String getProperty() {
        return NUM_CONFLICTS_PROP;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    @Override
    public int getRowCount() {
        return this.getNumDecisions();
    }

    @Override
    public Object getValueAt(int n, int n2) {
        if (this.decisions == null) {
            return null;
        }
        RelationMemberConflictDecision relationMemberConflictDecision = this.decisions.get(n);
        switch (n2) {
            case 0: {
                return relationMemberConflictDecision.getRelation();
            }
            case 1: {
                return Integer.toString(relationMemberConflictDecision.getPos() + 1);
            }
            case 2: {
                return relationMemberConflictDecision.getRole();
            }
            case 3: {
                return relationMemberConflictDecision.getOriginalPrimitive();
            }
            case 4: {
                return relationMemberConflictDecision.getDecision();
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        RelationMemberConflictDecision relationMemberConflictDecision = this.decisions.get(n);
        switch (n2) {
            case 2: {
                relationMemberConflictDecision.setRole((String)object);
                break;
            }
            case 4: {
                relationMemberConflictDecision.decide((RelationMemberConflictDecisionType)((Object)object));
                this.refresh();
                break;
            }
        }
        this.fireTableDataChanged();
    }

    protected void populate(Relation relation, OsmPrimitive osmPrimitive) {
        for (int i = 0; i < relation.getMembersCount(); ++i) {
            if (!relation.getMember(i).refersTo(osmPrimitive)) continue;
            this.decisions.add(new RelationMemberConflictDecision(relation, i));
        }
    }

    public void populate(Collection<Relation> collection, Collection<? extends OsmPrimitive> linkedList) {
        this.decisions.clear();
        collection = collection == null ? Collections.emptyList() : collection;
        linkedList = linkedList == null ? new LinkedList<OsmPrimitive>() : linkedList;
        for (Relation relation : collection) {
            for (OsmPrimitive osmPrimitive : linkedList) {
                this.populate(relation, osmPrimitive);
            }
        }
        this.relations = collection;
        this.primitives = linkedList;
        this.refresh();
    }

    public void populate(Collection<RelationToChildReference> linkedList) {
        linkedList = linkedList == null ? new LinkedList() : linkedList;
        this.decisions.clear();
        this.relations = new HashSet<Relation>(linkedList.size());
        HashSet<? extends OsmPrimitive> hashSet = new HashSet<OsmPrimitive>();
        for (RelationToChildReference relationToChildReference : linkedList) {
            this.decisions.add(new RelationMemberConflictDecision(relationToChildReference.getParent(), relationToChildReference.getPosition()));
            this.relations.add(relationToChildReference.getParent());
            hashSet.add(relationToChildReference.getChild());
        }
        this.primitives = hashSet;
        this.refresh();
    }

    public void prepareDefaultRelationDecisions() {
        if (Utils.forAll(this.primitives, OsmPrimitive.nodePredicate)) {
            HashSet hashSet = new HashSet();
            for (RelationMemberConflictDecision relationMemberConflictDecision : this.decisions) {
                hashSet.add(relationMemberConflictDecision.getOriginalPrimitive());
            }
            if (hashSet.size() == 1) {
                for (RelationMemberConflictDecision relationMemberConflictDecision : this.decisions) {
                    relationMemberConflictDecision.decide(RelationMemberConflictDecisionType.KEEP);
                }
                this.refresh();
                return;
            }
        }
        for (Relation relation : this.relations) {
            Object object2;
            LinkedHashMap linkedHashMap = new LinkedHashMap(this.primitives.size(), 1.0f);
            for (RelationMemberConflictDecision relationMemberConflictDecision : this.decisions) {
                if (relationMemberConflictDecision.getRelation() != relation) continue;
                object2 = relationMemberConflictDecision.getOriginalPrimitive();
                if (!linkedHashMap.containsKey(object2)) {
                    linkedHashMap.put((OsmPrimitive)object2, new ArrayList());
                }
                ((List)linkedHashMap.get(object2)).add(relationMemberConflictDecision);
            }
            if (!linkedHashMap.keySet().containsAll(this.primitives)) continue;
            ArrayList arrayList = new ArrayList(this.primitives.size());
            for (Object object2 : linkedHashMap.values()) {
                arrayList.add(object2.iterator());
            }
            while (Utils.forAll(arrayList, new Predicate<Iterator<RelationMemberConflictDecision>>(){

                @Override
                public boolean evaluate(Iterator<RelationMemberConflictDecision> iterator) {
                    return iterator.hasNext();
                }
            })) {
                ArrayList<RelationMemberConflictDecision> arrayList2 = new ArrayList<RelationMemberConflictDecision>();
                object2 = new HashSet<String>();
                TreeSet<Integer> treeSet = new TreeSet<Integer>();
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    Object object3 = (Iterator)iterator.next();
                    RelationMemberConflictDecision relationMemberConflictDecision = (RelationMemberConflictDecision)object3.next();
                    arrayList2.add(relationMemberConflictDecision);
                    object2.add(relationMemberConflictDecision.getRole());
                    treeSet.add(relationMemberConflictDecision.getPos());
                }
                if (object2.size() != 1 || !RelationMemberConflictResolverModel.isCollectionOfConsecutiveNumbers(treeSet)) continue;
                ((RelationMemberConflictDecision)arrayList2.get(0)).decide(RelationMemberConflictDecisionType.KEEP);
                for (Object object3 : arrayList2.subList(1, arrayList2.size())) {
                    ((RelationMemberConflictDecision)object3).decide(RelationMemberConflictDecisionType.REMOVE);
                }
            }
        }
        this.refresh();
    }

    static boolean isCollectionOfConsecutiveNumbers(Collection<Integer> collection) {
        if (collection.isEmpty()) {
            return true;
        }
        Iterator<Integer> iterator = collection.iterator();
        Integer n = iterator.next();
        while (iterator.hasNext()) {
            Integer n2 = iterator.next();
            if (n + 1 != n2) {
                return false;
            }
            n = n2;
        }
        return true;
    }

    public RelationMemberConflictDecision getDecision(int n) {
        return this.decisions.get(n);
    }

    public int getNumDecisions() {
        return this.decisions == null ? 0 : this.decisions.size();
    }

    public void refresh() {
        this.updateNumConflicts();
        GuiHelper.runInEDTAndWait(new Runnable(){

            @Override
            public void run() {
                RelationMemberConflictResolverModel.this.fireTableDataChanged();
            }
        });
    }

    public void applyRole(String string) {
        string = string == null ? "" : string;
        for (RelationMemberConflictDecision relationMemberConflictDecision : this.decisions) {
            relationMemberConflictDecision.setRole(string);
        }
        this.refresh();
    }

    protected RelationMemberConflictDecision getDecision(Relation relation, int n) {
        for (RelationMemberConflictDecision relationMemberConflictDecision : this.decisions) {
            if (!relationMemberConflictDecision.matches(relation, n)) continue;
            return relationMemberConflictDecision;
        }
        return null;
    }

    protected Command buildResolveCommand(Relation relation, OsmPrimitive osmPrimitive) {
        Relation relation2 = new Relation(relation);
        relation2.setMembers(null);
        boolean bl = false;
        block4: for (int i = 0; i < relation.getMembersCount(); ++i) {
            RelationMember relationMember = relation.getMember(i);
            RelationMemberConflictDecision relationMemberConflictDecision = this.getDecision(relation, i);
            if (relationMemberConflictDecision == null) {
                relation2.addMember(relationMember);
                continue;
            }
            switch (relationMemberConflictDecision.getDecision()) {
                case KEEP: {
                    RelationMember relationMember2 = new RelationMember(relationMemberConflictDecision.getRole(), osmPrimitive);
                    relation2.addMember(relationMember2);
                    bl |= !relationMember.equals(relationMember2);
                    continue block4;
                }
                case REMOVE: {
                    bl = true;
                    continue block4;
                }
            }
        }
        if (bl) {
            return new ChangeCommand(relation, relation2);
        }
        return null;
    }

    public List<Command> buildResolutionCommands(OsmPrimitive osmPrimitive) {
        LinkedList<Command> linkedList = new LinkedList<Command>();
        for (Relation relation : this.relations) {
            Command command = this.buildResolveCommand(relation, osmPrimitive);
            if (command == null) continue;
            linkedList.add(command);
        }
        return linkedList;
    }

    protected boolean isChanged(Relation relation, OsmPrimitive osmPrimitive) {
        block4: for (int i = 0; i < relation.getMembersCount(); ++i) {
            RelationMemberConflictDecision relationMemberConflictDecision = this.getDecision(relation, i);
            if (relationMemberConflictDecision == null) continue;
            switch (relationMemberConflictDecision.getDecision()) {
                case REMOVE: {
                    return true;
                }
                case KEEP: {
                    if (!relation.getMember(i).getRole().equals(relationMemberConflictDecision.getRole())) {
                        return true;
                    }
                    if (relation.getMember(i).getMember() == osmPrimitive) continue block4;
                    return true;
                }
            }
        }
        return false;
    }

    public Set<Relation> getModifiedRelations(OsmPrimitive osmPrimitive) {
        HashSet<Relation> hashSet = new HashSet<Relation>();
        for (Relation relation : this.relations) {
            if (!this.isChanged(relation, osmPrimitive)) continue;
            hashSet.add(relation);
        }
        return hashSet;
    }
}

