/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.ExtensionFileFilter;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.io.Compression;
import org.openstreetmap.josm.io.FileExporter;
import org.openstreetmap.josm.io.OsmWriter;
import org.openstreetmap.josm.io.OsmWriterFactory;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;

public class OsmExporter
extends FileExporter {
    public OsmExporter() {
        super(new ExtensionFileFilter("osm,xml", "osm", I18n.tr("OSM Server Files", new Object[0]) + " (*.osm)"));
    }

    public OsmExporter(ExtensionFileFilter extensionFileFilter) {
        super(extensionFileFilter);
    }

    @Override
    public boolean acceptFile(File file, Layer layer) {
        if (!(layer instanceof OsmDataLayer)) {
            return false;
        }
        return super.acceptFile(file, layer);
    }

    @Override
    public void exportData(File file, Layer layer) throws IOException {
        this.exportData(file, layer, false);
    }

    public void exportData(File file, Layer layer, boolean bl) {
        OsmExporter.checkOsmDataLayer(layer);
        this.save(file, (OsmDataLayer)layer, bl);
    }

    protected static void checkOsmDataLayer(Layer layer) {
        if (!(layer instanceof OsmDataLayer)) {
            throw new IllegalArgumentException(MessageFormat.format("Expected instance of OsmDataLayer. Got ''{0}''.", layer.getClass().getName()));
        }
    }

    protected static OutputStream getOutputStream(File file) throws FileNotFoundException, IOException {
        return Compression.getCompressedFileOutputStream(file);
    }

    private void save(File file, OsmDataLayer osmDataLayer, boolean bl) {
        File file2 = null;
        try {
            if (file.exists()) {
                file2 = new File(file.getPath() + '~');
                Utils.copyFile(file, file2);
            }
            this.doSave(file, osmDataLayer);
            if ((bl || !Main.pref.getBoolean("save.keepbackup", false)) && file2 != null) {
                Utils.deleteFile(file2);
            }
            osmDataLayer.onPostSaveToFile();
        }
        catch (IOException iOException) {
            Main.error(iOException);
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("<html>An error occurred while saving.<br>Error is:<br>{0}</html>", iOException.getMessage()), I18n.tr("Error", new Object[0]), 0);
            try {
                if (file2 != null && file2.exists()) {
                    Utils.copyFile(file2, file);
                }
            }
            catch (IOException iOException2) {
                Main.error(iOException2);
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("<html>An error occurred while restoring backup file.<br>Error is:<br>{0}</html>", iOException2.getMessage()), I18n.tr("Error", new Object[0]), 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doSave(File file, OsmDataLayer osmDataLayer) throws IOException, FileNotFoundException {
        try (OutputStream outputStream = OsmExporter.getOutputStream(file);
             OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, StandardCharsets.UTF_8);
             OsmWriter osmWriter = OsmWriterFactory.createOsmWriter(new PrintWriter(outputStreamWriter), false, osmDataLayer.data.getVersion());){
            osmDataLayer.data.getReadLock().lock();
            try {
                osmWriter.writeLayer(osmDataLayer);
            }
            finally {
                osmDataLayer.data.getReadLock().unlock();
            }
        }
    }
}

