/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.pscan.scanner;

import java.util.List;
import net.htmlparser.jericho.Source;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.core.scanner.Alert;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.zap.extension.pscan.PassiveScanThread;
import org.zaproxy.zap.extension.pscan.PassiveScript;
import org.zaproxy.zap.extension.pscan.PluginPassiveScanner;
import org.zaproxy.zap.extension.script.ExtensionScript;
import org.zaproxy.zap.extension.script.ScriptWrapper;

public class ScriptsPassiveScanner
extends PluginPassiveScanner {
    private ExtensionScript extension = null;
    private PassiveScanThread parent = null;
    private String name = null;
    private int currentHRefId;

    @Override
    public String getName() {
        if (this.name == null) {
            if (Constant.messages.containsKey("pscan.scripts.passivescanner.title")) {
                this.name = Constant.messages.getString("pscan.scripts.passivescanner.title");
            }
            this.name = "Script passive scan rules";
        }
        return this.name;
    }

    private ExtensionScript getExtension() {
        if (this.extension == null) {
            this.extension = (ExtensionScript)Control.getSingleton().getExtensionLoader().getExtension("ExtensionScript");
        }
        return this.extension;
    }

    @Override
    public int getPluginId() {
        return 50001;
    }

    @Override
    public void scanHttpRequestSend(HttpMessage httpMessage, int n) {
    }

    @Override
    public void scanHttpResponseReceive(HttpMessage httpMessage, int n, Source source) {
        if (this.getExtension() != null) {
            this.currentHRefId = n;
            List<ScriptWrapper> list = this.extension.getScripts("passive");
            for (ScriptWrapper scriptWrapper : list) {
                try {
                    if (!scriptWrapper.isEnabled()) continue;
                    PassiveScript passiveScript = this.extension.getInterface(scriptWrapper, PassiveScript.class);
                    if (passiveScript != null) {
                        passiveScript.scan(this, httpMessage, source);
                        continue;
                    }
                    this.extension.handleFailedScriptInterface(scriptWrapper, Constant.messages.getString("pscan.scripts.interface.passive.error", scriptWrapper.getName()));
                }
                catch (Exception exception) {
                    this.extension.handleScriptException(scriptWrapper, exception);
                }
            }
        }
    }

    public void raiseAlert(int n, int n2, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, int n3, int n4, HttpMessage httpMessage) {
        Alert alert = new Alert(this.getPluginId(), n, n2, string);
        alert.setDetail(string2, httpMessage.getRequestHeader().getURI().toString(), string4, string5, string6, string7, null, string8, n3, n4, httpMessage);
        this.parent.raiseAlert(this.currentHRefId, alert);
    }

    @Override
    public void setParent(PassiveScanThread passiveScanThread) {
        this.parent = passiveScanThread;
    }
}

