/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.view.messagelocation;

import java.awt.Component;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.SortOrder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.jdesktop.swingx.JXTable;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.extension.httppanel.ComponentChangedEvent;
import org.zaproxy.zap.extension.httppanel.MessagePanelEventListener;
import org.zaproxy.zap.extension.httppanel.MessageViewSelectedEvent;
import org.zaproxy.zap.extension.httppanel.view.HttpPanelView;
import org.zaproxy.zap.model.MessageLocation;
import org.zaproxy.zap.view.AbstractMultipleOptionsBaseTableModel;
import org.zaproxy.zap.view.AbstractMultipleOptionsBaseTablePanel;
import org.zaproxy.zap.view.messagelocation.HighlightChangedEvent;
import org.zaproxy.zap.view.messagelocation.HighlightChangedListener;
import org.zaproxy.zap.view.messagelocation.MessageLocationHighlight;
import org.zaproxy.zap.view.messagelocation.MessageLocationHighlightRenderersEditors;
import org.zaproxy.zap.view.messagelocation.MessageLocationHighlighter;
import org.zaproxy.zap.view.messagelocation.MessageLocationHighlightsManager;
import org.zaproxy.zap.view.messagelocation.MessageLocationProducerFocusEvent;
import org.zaproxy.zap.view.messagelocation.MessageLocationProducerFocusListener;
import org.zaproxy.zap.view.messagelocation.MessageLocationTableEntry;
import org.zaproxy.zap.view.messagelocation.MessageLocationsTableModel;
import org.zaproxy.zap.view.messagelocation.SelectMessageLocationsPanel;

public abstract class AbstractMessageLocationsPanel<T extends MessageLocationTableEntry, S extends MessageLocationsTableModel<T>>
extends AbstractMultipleOptionsBaseTablePanel<T> {
    private static final long serialVersionUID = -8990789229815588716L;
    private static final String REMOVE_DIALOG_TITLE = Constant.messages.getString("messagelocationspanel.dialog.remove.location.title");
    private static final String REMOVE_DIALOG_TEXT = Constant.messages.getString("messagelocationspanel.dialog.remove.location.text");
    private static final String REMOVE_DIALOG_CONFIRM_BUTTON_LABEL = Constant.messages.getString("messagelocationspanel.dialog.remove.location.button.confirm");
    private static final String REMOVE_DIALOG_CANCEL_BUTTON_LABEL = Constant.messages.getString("messagelocationspanel.dialog.remove.location.button.cancel");
    private static final String REMOVE_DIALOG_CHECKBOX_LABEL = Constant.messages.getString("messagelocationspanel.dialog.remove.location.checkbox.label");
    private MessageLocationProducerFocusListener addButtonFocusListenerEnabler;
    private SelectMessageLocationsPanel selectMessageLocationsPanel;
    private final Component parent;

    public AbstractMessageLocationsPanel(Component component, SelectMessageLocationsPanel selectMessageLocationsPanel, S s) {
        this(component, selectMessageLocationsPanel, s, false);
    }

    public AbstractMessageLocationsPanel(Component component, SelectMessageLocationsPanel selectMessageLocationsPanel, S s, boolean bl) {
        super(s, bl);
        this.parent = component;
        this.selectMessageLocationsPanel = selectMessageLocationsPanel;
        this.selectMessageLocationsPanel.addMessagePanelEventListener(this.createMessagePanelEventListener());
        ((MessageLocationsTableModel)this.getModel()).addMessageLocationHighlightChangedListener(this.createHighlightChangedListener());
        this.addButton.setEnabled(false);
        this.addButton.setToolTipText(Constant.messages.getString("messagelocationspanel.add.location.tooltip"));
        this.addButtonFocusListenerEnabler = this.createFocusListener();
        this.getTable().setSortOrder(1, SortOrder.ASCENDING);
        this.getTable().setDefaultRenderer(MessageLocationHighlight.class, (TableCellRenderer)new DefaultMessageLocationHighlightRenderer());
        this.getRemoveWithoutConfirmationCheckBox().setSelected(true);
    }

    protected MessagePanelEventListener createMessagePanelEventListener() {
        return new MessagePanelEventListener(){

            @Override
            public void componentChanged(ComponentChangedEvent componentChangedEvent) {
                for (MessageLocationTableEntry messageLocationTableEntry : ((MessageLocationsTableModel)AbstractMessageLocationsPanel.this.getModel()).getElements()) {
                    MessageLocationHighlight messageLocationHighlight = messageLocationTableEntry.getHighlight();
                    if (messageLocationHighlight == null) continue;
                    MessageLocationHighlight messageLocationHighlight2 = AbstractMessageLocationsPanel.this.selectMessageLocationsPanel.highlight(messageLocationTableEntry.getLocation(), messageLocationHighlight);
                    messageLocationTableEntry.setHighlightReference(messageLocationHighlight2);
                }
            }

            @Override
            public void viewSelected(MessageViewSelectedEvent messageViewSelectedEvent) {
                HttpPanelView httpPanelView = messageViewSelectedEvent.getCurrentView();
                if (httpPanelView instanceof MessageLocationHighlighter) {
                    MessageLocationHighlighter messageLocationHighlighter = (MessageLocationHighlighter)((Object)httpPanelView);
                    for (MessageLocationTableEntry messageLocationTableEntry : ((MessageLocationsTableModel)AbstractMessageLocationsPanel.this.getModel()).getElements()) {
                        MessageLocationHighlight messageLocationHighlight = messageLocationTableEntry.getHighlight();
                        if (messageLocationHighlight == null) continue;
                        MessageLocationHighlight messageLocationHighlight2 = messageLocationHighlighter.highlight(messageLocationTableEntry.getLocation(), messageLocationHighlight);
                        messageLocationTableEntry.setHighlightReference(messageLocationHighlight2);
                    }
                } else {
                    for (MessageLocationTableEntry messageLocationTableEntry : ((MessageLocationsTableModel)AbstractMessageLocationsPanel.this.getModel()).getElements()) {
                        messageLocationTableEntry.setHighlightReference(null);
                    }
                }
            }
        };
    }

    protected HighlightChangedListener<T> createHighlightChangedListener() {
        return new MessageLocationsHighlightChangedListener();
    }

    @Override
    protected JXTable createTable() {
        MessageLocationsTable messageLocationsTable = new MessageLocationsTable();
        messageLocationsTable.setSelectionMode(0);
        messageLocationsTable.setColumnControlVisible(true);
        return messageLocationsTable;
    }

    public MessageLocationProducerFocusListener getFocusListenerAddButtonEnabler() {
        return this.addButtonFocusListenerEnabler;
    }

    protected MessageLocationProducerFocusListener createFocusListener() {
        return new MessageLocationsFocusListener();
    }

    @Override
    public T showAddDialogue() {
        this.addButton.setEnabled(false);
        return this.addMessageLocationImpl(true, this.selectMessageLocationsPanel.getSelection());
    }

    public boolean addMessageLocation(MessageLocation messageLocation) {
        if (messageLocation == null) {
            throw new IllegalArgumentException("Parameter messageLocation must not be null.");
        }
        return this.addMessageLocationImpl(false, messageLocation) != null;
    }

    private T addMessageLocationImpl(boolean bl, MessageLocation messageLocation) {
        T t;
        Object object2;
        for (Object object2 : ((MessageLocationsTableModel)this.getModel()).getElements()) {
            if (!((MessageLocationTableEntry)object2).getLocation().overlaps(messageLocation)) continue;
            View.getSingleton().showWarningDialog(Constant.messages.getString("messagelocationspanel.add.location.warning.locations.overlap"));
            return null;
        }
        Object object3 = null;
        object2 = null;
        MessageLocationHighlightsManager messageLocationHighlightsManager = this.selectMessageLocationsPanel.create();
        if (messageLocationHighlightsManager != null) {
            object3 = messageLocationHighlightsManager.getHighlight(messageLocation);
            object2 = this.selectMessageLocationsPanel.highlight(messageLocation, (MessageLocationHighlight)object3);
        }
        if ((t = this.createMessageLocationTableEntry(bl, messageLocation, (MessageLocationHighlight)object3, (MessageLocationHighlight)object2)) == null) {
            if (messageLocationHighlightsManager != null) {
                this.selectMessageLocationsPanel.removeHighlight(messageLocation, (MessageLocationHighlight)object2);
            }
            return null;
        }
        ((AbstractMultipleOptionsBaseTableModel)this.getModel()).addElement(t);
        int n = this.getTable().convertRowIndexToView(((MessageLocationsTableModel)this.getModel()).getRow((MessageLocationTableEntry)t));
        this.getTable().setRowSelectionInterval(n, n);
        return null;
    }

    protected abstract T createMessageLocationTableEntry(boolean var1, MessageLocation var2, MessageLocationHighlight var3, MessageLocationHighlight var4);

    @Override
    public T showModifyDialogue(T t) {
        return null;
    }

    @Override
    public boolean showRemoveDialogue(T t) {
        if (!this.getRemoveWithoutConfirmationCheckBox().isSelected() && !this.showRemoveDialogueImpl(t)) {
            return false;
        }
        MessageLocationHighlight messageLocationHighlight = ((MessageLocationTableEntry)t).getHighlightReference();
        if (messageLocationHighlight != null) {
            this.selectMessageLocationsPanel.removeHighlight(((MessageLocationTableEntry)t).getLocation(), messageLocationHighlight);
        }
        return true;
    }

    protected Component getParentOwner() {
        return this.parent;
    }

    protected boolean showRemoveDialogueImpl(T t) {
        JCheckBox jCheckBox = new JCheckBox(REMOVE_DIALOG_CHECKBOX_LABEL);
        Object[] objectArray = new Object[]{REMOVE_DIALOG_TEXT, " ", jCheckBox};
        int n = JOptionPane.showOptionDialog(View.getSingleton().getMainFrame(), objectArray, REMOVE_DIALOG_TITLE, 2, 3, null, new String[]{REMOVE_DIALOG_CONFIRM_BUTTON_LABEL, REMOVE_DIALOG_CANCEL_BUTTON_LABEL}, null);
        if (n == 0) {
            this.getRemoveWithoutConfirmationCheckBox().setSelected(jCheckBox.isSelected());
            return true;
        }
        return false;
    }

    @Override
    public boolean isRemoveWithoutConfirmation() {
        return false;
    }

    public void reset() {
        for (MessageLocationTableEntry messageLocationTableEntry : this.getMultipleOptionsModel().getElements()) {
            MessageLocationHighlight messageLocationHighlight = messageLocationTableEntry.getHighlightReference();
            if (messageLocationHighlight == null) continue;
            this.selectMessageLocationsPanel.removeHighlight(messageLocationTableEntry.getLocation(), messageLocationHighlight);
        }
        this.getMultipleOptionsModel().clear();
    }

    protected S getModel() {
        MessageLocationsTableModel messageLocationsTableModel = (MessageLocationsTableModel)super.getMultipleOptionsModel();
        return (S)messageLocationsTableModel;
    }

    protected class MessageLocationsFocusListener
    implements MessageLocationProducerFocusListener {
        protected MessageLocationsFocusListener() {
        }

        @Override
        public void focusLost(MessageLocationProducerFocusEvent messageLocationProducerFocusEvent) {
            if (messageLocationProducerFocusEvent.getFocusEvent().getOppositeComponent() != AbstractMessageLocationsPanel.this.addButton) {
                AbstractMessageLocationsPanel.this.addButton.setEnabled(false);
            }
        }

        @Override
        public void focusGained(MessageLocationProducerFocusEvent messageLocationProducerFocusEvent) {
            AbstractMessageLocationsPanel.this.addButton.setEnabled(true);
        }
    }

    protected class MessageLocationsHighlightChangedListener
    implements HighlightChangedListener<T> {
        protected MessageLocationsHighlightChangedListener() {
        }

        @Override
        public void highlightChanged(HighlightChangedEvent<T> highlightChangedEvent) {
            MessageLocationHighlight messageLocationHighlight;
            MessageLocationTableEntry messageLocationTableEntry = (MessageLocationTableEntry)highlightChangedEvent.getEntry();
            MessageLocationHighlight messageLocationHighlight2 = highlightChangedEvent.getHighlightReference();
            if (messageLocationHighlight2 != null) {
                AbstractMessageLocationsPanel.this.selectMessageLocationsPanel.removeHighlight(messageLocationTableEntry.getLocation(), highlightChangedEvent.getHighlightReference());
            }
            if ((messageLocationHighlight = messageLocationTableEntry.getHighlight()) != null) {
                messageLocationHighlight2 = AbstractMessageLocationsPanel.this.selectMessageLocationsPanel.highlight(messageLocationTableEntry.getLocation(), messageLocationTableEntry.getHighlight());
                messageLocationTableEntry.setHighlightReference(messageLocationHighlight2);
            }
        }
    }

    protected class MessageLocationsTable
    extends JXTable {
        private static final long serialVersionUID = -3277532157790764376L;

        protected MessageLocationsTable() {
        }

        public TableCellEditor getCellEditor(int n, int n2) {
            TableCellEditor tableCellEditor;
            Class<?> clazz = ((MessageLocationsTableModel)AbstractMessageLocationsPanel.this.getModel()).getColumnClass(n, n2);
            if (clazz != null && MessageLocationHighlight.class.isAssignableFrom(clazz) && (tableCellEditor = MessageLocationHighlightRenderersEditors.getInstance().getEditor(clazz)) != null) {
                return tableCellEditor;
            }
            return super.getCellEditor(n, n2);
        }

        public TableCellRenderer getCellRenderer(int n, int n2) {
            TableCellRenderer tableCellRenderer;
            Class<?> clazz = ((MessageLocationsTableModel)AbstractMessageLocationsPanel.this.getModel()).getColumnClass(n, n2);
            if (clazz != null && MessageLocationHighlight.class.isAssignableFrom(clazz) && (tableCellRenderer = MessageLocationHighlightRenderersEditors.getInstance().getRenderer(clazz)) != null) {
                return tableCellRenderer;
            }
            return super.getCellRenderer(n, n2);
        }
    }

    private static class DefaultMessageLocationHighlightRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 427590735065539815L;

        private DefaultMessageLocationHighlightRenderer() {
        }

        @Override
        protected void setValue(Object object) {
        }
    }
}

