/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.charts.swing;

import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.plaf.basic.BasicLabelUI;
import javax.swing.text.View;

public class RotateLabelUI
extends BasicLabelUI {
    private static final double ROTATE_0 = 0.0;
    private static final double ROTATE_90 = 1.5707963267948966;
    private static final double ROTATE_180 = Math.PI;
    private static final double ROTATE_270 = -1.5707963267948966;
    public static final RotateLabelUI R0 = RotateLabelUI.rotate0();
    public static final RotateLabelUI R90 = RotateLabelUI.rotate90();
    public static final RotateLabelUI R180 = RotateLabelUI.rotate180();
    public static final RotateLabelUI R270 = RotateLabelUI.rotate270();
    private final double rotation;
    private final boolean vertical;
    private static Rectangle paintIconR = new Rectangle();
    private static Rectangle paintTextR = new Rectangle();
    private static Rectangle paintViewR = new Rectangle();
    private static Insets paintViewInsets = new Insets(0, 0, 0, 0);

    private static RotateLabelUI rotate0() {
        return new RotateLabelUI(0.0);
    }

    private static RotateLabelUI rotate90() {
        return new RotateLabelUI(1.5707963267948966);
    }

    private static RotateLabelUI rotate180() {
        return new RotateLabelUI(Math.PI);
    }

    private static RotateLabelUI rotate270() {
        return new RotateLabelUI(-1.5707963267948966);
    }

    private RotateLabelUI(double rotation) {
        this.rotation = rotation;
        this.vertical = rotation == 1.5707963267948966 || rotation == -1.5707963267948966;
    }

    public void paint(Graphics g, JComponent c) {
        Icon icon;
        JLabel label = (JLabel)c;
        String text = label.getText();
        Icon icon2 = icon = label.isEnabled() ? label.getIcon() : label.getDisabledIcon();
        if (icon == null && text == null) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        AffineTransform transform = null;
        if (this.rotation != 0.0) {
            transform = g2.getTransform();
            g2.rotate(this.rotation);
            if (this.rotation == 1.5707963267948966) {
                g2.translate(0, -c.getWidth());
            } else if (this.rotation == Math.PI) {
                g2.translate(-c.getWidth(), -c.getHeight());
            } else if (this.rotation == -1.5707963267948966) {
                g2.translate(-c.getHeight(), 0);
            }
        }
        FontMetrics fm = g.getFontMetrics();
        String clippedText = this.layout(label, fm, c.getWidth(), c.getHeight());
        if (icon != null) {
            icon.paintIcon(c, g, RotateLabelUI.paintIconR.x, RotateLabelUI.paintIconR.y);
        }
        if (text != null) {
            View v = (View)c.getClientProperty("html");
            if (v != null) {
                v.paint(g, paintTextR);
            } else {
                int textX = RotateLabelUI.paintTextR.x;
                int textY = RotateLabelUI.paintTextR.y + fm.getAscent();
                if (label.isEnabled()) {
                    this.paintEnabledText(label, g, clippedText, textX, textY);
                } else {
                    this.paintDisabledText(label, g, clippedText, textX, textY);
                }
            }
        }
        if (transform != null) {
            g2.setTransform(transform);
        }
    }

    private String layout(JLabel label, FontMetrics fm, int width, int height) {
        Insets insets = label.getInsets(paintViewInsets);
        String text = label.getText();
        Icon icon = label.isEnabled() ? label.getIcon() : label.getDisabledIcon();
        RotateLabelUI.paintViewR.x = insets.left;
        RotateLabelUI.paintViewR.y = insets.top;
        if (this.vertical) {
            RotateLabelUI.paintViewR.height = width - (insets.left + insets.right);
            RotateLabelUI.paintViewR.width = height - (insets.top + insets.bottom);
        } else {
            RotateLabelUI.paintViewR.width = width - (insets.left + insets.right);
            RotateLabelUI.paintViewR.height = height - (insets.top + insets.bottom);
        }
        RotateLabelUI.paintIconR.height = 0;
        RotateLabelUI.paintIconR.width = 0;
        RotateLabelUI.paintIconR.y = 0;
        RotateLabelUI.paintIconR.x = 0;
        RotateLabelUI.paintTextR.height = 0;
        RotateLabelUI.paintTextR.width = 0;
        RotateLabelUI.paintTextR.y = 0;
        RotateLabelUI.paintTextR.x = 0;
        return this.layoutCL(label, fm, text, icon, paintViewR, paintIconR, paintTextR);
    }

    public Dimension getPreferredSize(JComponent c) {
        return this.getDimension(super.getPreferredSize(c));
    }

    public Dimension getMinimumSize(JComponent c) {
        return this.getDimension(super.getMinimumSize(c));
    }

    public Dimension getMaximumSize(JComponent c) {
        return this.getDimension(super.getMaximumSize(c));
    }

    private Dimension getDimension(Dimension dimension) {
        if (!this.vertical) {
            return dimension;
        }
        int width = dimension.width;
        dimension.width = dimension.height;
        dimension.height = width;
        return dimension;
    }
}

