/*
 * Decompiled with CFR 0.152.
 */
package com.github.mustachejava.util;

import com.github.mustachejava.util.State;
import java.io.IOException;
import java.io.Writer;

public class StateAwareWriter<T extends State>
extends Writer {
    private Writer writer;
    private T state;

    public StateAwareWriter(Writer writer, T state) {
        this.writer = writer;
        this.state = state;
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        this.state.nextState(cbuf, off, len);
        this.writer.write(cbuf, off, len);
    }

    @Override
    public void flush() throws IOException {
        this.writer.flush();
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.writer.close();
    }
}

