/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.percolator;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchWrapperException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.shard.ShardId;

public class PercolateException
extends ElasticsearchException
implements ElasticsearchWrapperException {
    private final ShardId shardId;

    public PercolateException(ShardId shardId, String msg, Throwable cause) {
        super(msg, cause, new Object[0]);
        Objects.requireNonNull(shardId, "shardId must not be null");
        this.shardId = shardId;
    }

    @Override
    public ShardId getShardId() {
        return this.shardId;
    }

    public PercolateException(StreamInput in) throws IOException {
        super(in);
        this.shardId = ShardId.readShardId(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.shardId.writeTo(out);
    }
}

