/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language.exceptions;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.language.RubyNode;

public class DisablingBacktracesNode
extends RubyNode {
    @Node.Child
    private RubyNode child;
    private static ThreadLocal<Boolean> areBacktracesDisabledThreadLocal = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };

    public DisablingBacktracesNode(RubyContext context, SourceSection sourceSection, RubyNode child) {
        super(context, sourceSection);
        this.child = child;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object execute(VirtualFrame frame) {
        boolean backtracesPreviouslyDisabled = areBacktracesDisabledThreadLocal.get();
        try {
            areBacktracesDisabledThreadLocal.set(true);
            Object object = this.child.execute(frame);
            return object;
        }
        finally {
            areBacktracesDisabledThreadLocal.set(backtracesPreviouslyDisabled);
        }
    }

    public static boolean areBacktracesDisabled() {
        return areBacktracesDisabledThreadLocal.get();
    }
}

