/*
 * Decompiled with CFR 0.152.
 */
package org.encog.mathutil.randomize;

import java.util.Random;
import org.encog.mathutil.randomize.BasicRandomizer;

public class RangeRandomizer
extends BasicRandomizer {
    private final double min;
    private final double max;

    public static int randomInt(int min, int max) {
        return (int)RangeRandomizer.randomize(min, max + 1);
    }

    public static double randomize(double min, double max) {
        double range = max - min;
        return range * Math.random() + min;
    }

    public static double randomize(Random r, double min, double max) {
        double range = max - min;
        return range * r.nextDouble() + min;
    }

    public RangeRandomizer(double min, double max) {
        this.max = max;
        this.min = min;
    }

    @Override
    public double randomize(double d) {
        return this.nextDouble(this.min, this.max);
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }
}

