##############################################################################
#
# Copyright (c) 2012 Zope Foundation and Contributors.
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#
##############################################################################
import unittest


def _skip_under_py3(testcase):
    from zope.schema._compat import PY3
    if not PY3:
        return testcase


class ValidationErrorTests(unittest.TestCase):

    def _getTargetClass(self):
        from zope.schema._bootstrapinterfaces import ValidationError
        return ValidationError

    def _makeOne(self, *args, **kw):
        return self._getTargetClass()(*args, **kw)

    def test_doc(self):
        class Derived(self._getTargetClass()):
            """DERIVED"""
        inst = Derived()
        self.assertEqual(inst.doc(), 'DERIVED')

    @_skip_under_py3
    def test___cmp___no_args(self):
        # Py3k??
        ve = self._makeOne()
        self.assertEqual(cmp(ve, object()), -1)

    @_skip_under_py3
    def test___cmp___hit(self):
        # Py3k??
        left = self._makeOne('abc')
        right = self._makeOne('def')
        self.assertEqual(cmp(left, right), -1)
        self.assertEqual(cmp(left, left), 0)
        self.assertEqual(cmp(right, left), 1)

    def test___eq___no_args(self):
        ve = self._makeOne()
        self.assertEqual(ve == object(), False)

    def test___eq___w_args(self):
        left = self._makeOne('abc')
        right = self._makeOne('def')
        self.assertEqual(left == right, False)
        self.assertEqual(left == left, True)
        self.assertEqual(right == right, True)


def test_suite():
    return unittest.TestSuite((
        unittest.makeSuite(ValidationErrorTests),
    ))
