/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.expressions;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.expressions.Bindings;
import org.apache.lucene.expressions.Expression;
import org.apache.lucene.expressions.ExpressionFunctionValues;
import org.apache.lucene.expressions.ExpressionSortField;
import org.apache.lucene.expressions.ScoreValueSource;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.search.SortField;

final class ExpressionValueSource
extends ValueSource {
    final ValueSource[] variables;
    final Expression expression;
    final boolean needsScores;

    ExpressionValueSource(Bindings bindings, Expression expression) {
        if (bindings == null) {
            throw new NullPointerException();
        }
        if (expression == null) {
            throw new NullPointerException();
        }
        this.expression = expression;
        this.variables = new ValueSource[expression.variables.length];
        boolean needsScores = false;
        for (int i = 0; i < this.variables.length; ++i) {
            ValueSource source = bindings.getValueSource(expression.variables[i]);
            if (source instanceof ScoreValueSource) {
                needsScores = true;
            } else if (source instanceof ExpressionValueSource) {
                if (((ExpressionValueSource)source).needsScores()) {
                    needsScores = true;
                }
            } else if (source == null) {
                throw new RuntimeException("Internal error. Variable (" + expression.variables[i] + ") does not exist.");
            }
            this.variables[i] = source;
        }
        this.needsScores = needsScores;
    }

    public FunctionValues getValues(Map context, LeafReaderContext readerContext) throws IOException {
        HashMap<String, FunctionValues> valuesCache = (HashMap<String, FunctionValues>)context.get("valuesCache");
        if (valuesCache == null) {
            valuesCache = new HashMap<String, FunctionValues>();
            context = new HashMap<String, HashMap<String, FunctionValues>>(context);
            context.put("valuesCache", valuesCache);
        }
        FunctionValues[] externalValues = new FunctionValues[this.expression.variables.length];
        for (int i = 0; i < this.variables.length; ++i) {
            String externalName = this.expression.variables[i];
            FunctionValues values = (FunctionValues)valuesCache.get(externalName);
            if (values == null) {
                values = this.variables[i].getValues(context, readerContext);
                if (values == null) {
                    throw new RuntimeException("Internal error. External (" + externalName + ") does not exist.");
                }
                valuesCache.put(externalName, values);
            }
            externalValues[i] = values;
        }
        return new ExpressionFunctionValues(this, this.expression, externalValues);
    }

    public SortField getSortField(boolean reverse) {
        return new ExpressionSortField(this.expression.sourceText, this, reverse);
    }

    public String description() {
        return "expr(" + this.expression.sourceText + ")";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.expression == null ? 0 : this.expression.hashCode());
        result = 31 * result + (this.needsScores ? 1231 : 1237);
        result = 31 * result + Arrays.hashCode(this.variables);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        ExpressionValueSource other = (ExpressionValueSource)((Object)obj);
        if (this.expression == null ? other.expression != null : !this.expression.equals(other.expression)) {
            return false;
        }
        if (this.needsScores != other.needsScores) {
            return false;
        }
        return Arrays.equals(this.variables, other.variables);
    }

    boolean needsScores() {
        return this.needsScores;
    }
}

