/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster;

import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.cluster.ClusterState;

public abstract class ClusterStateTaskExecutor<T> {
    public abstract BatchResult<T> execute(ClusterState var1, List<T> var2) throws Exception;

    public boolean runOnlyOnMaster() {
        return true;
    }

    public void clusterStatePublished(ClusterState newClusterState) {
    }

    public static class TaskResult {
        private final Throwable failure;
        private static final TaskResult SUCCESS = new TaskResult(null);

        public static TaskResult success() {
            return SUCCESS;
        }

        public static TaskResult failure(Throwable failure) {
            return new TaskResult(failure);
        }

        private TaskResult(Throwable failure) {
            this.failure = failure;
        }

        public boolean isSuccess() {
            return this.failure != null;
        }

        public void handle(Runnable onSuccess, FailureConsumer onFailure) {
            if (this.failure == null) {
                onSuccess.run();
            } else {
                onFailure.accept(this.failure);
            }
        }

        public static interface FailureConsumer {
            public void accept(Throwable var1);
        }
    }

    public static class BatchResult<T> {
        public final ClusterState resultingState;
        public final Map<T, TaskResult> executionResults;

        BatchResult(ClusterState resultingState, Map<T, TaskResult> executionResults) {
            this.resultingState = resultingState;
            this.executionResults = executionResults;
        }

        public static <T> Builder<T> builder() {
            return new Builder();
        }

        public static class Builder<T> {
            private final Map<T, TaskResult> executionResults = new IdentityHashMap<T, TaskResult>();

            public Builder<T> success(T task) {
                return this.result(task, TaskResult.success());
            }

            public Builder<T> successes(Iterable<T> tasks) {
                for (T task : tasks) {
                    this.success(task);
                }
                return this;
            }

            public Builder<T> failure(T task, Throwable t) {
                return this.result(task, TaskResult.failure(t));
            }

            public Builder<T> failures(Iterable<T> tasks, Throwable t) {
                for (T task : tasks) {
                    this.failure(task, t);
                }
                return this;
            }

            private Builder<T> result(T task, TaskResult executionResult) {
                this.executionResults.put(task, executionResult);
                return this;
            }

            public BatchResult<T> build(ClusterState resultingState) {
                return new BatchResult<T>(resultingState, this.executionResults);
            }
        }
    }
}

