/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.significant;

import java.io.IOException;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.significant.SignificantStringTerms;
import org.elasticsearch.search.aggregations.bucket.significant.SignificantTermsParametersParser;
import org.elasticsearch.search.aggregations.bucket.significant.heuristics.SignificanceHeuristicBuilder;
import org.elasticsearch.search.aggregations.bucket.terms.AbstractTermsParametersParser;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregator;

public class SignificantTermsBuilder
extends AggregationBuilder<SignificantTermsBuilder> {
    private TermsAggregator.BucketCountThresholds bucketCountThresholds = new TermsAggregator.BucketCountThresholds(-1L, -1L, -1, -1);
    private String field;
    private String executionHint;
    private String includePattern;
    private int includeFlags;
    private String excludePattern;
    private int excludeFlags;
    private String[] includeTerms = null;
    private String[] excludeTerms = null;
    private QueryBuilder filterBuilder;
    private SignificanceHeuristicBuilder significanceHeuristicBuilder;

    public SignificantTermsBuilder(String name) {
        super(name, SignificantStringTerms.TYPE.name());
    }

    public SignificantTermsBuilder field(String field) {
        this.field = field;
        return this;
    }

    public SignificantTermsBuilder size(int requiredSize) {
        this.bucketCountThresholds.setRequiredSize(requiredSize);
        return this;
    }

    public SignificantTermsBuilder shardSize(int shardSize) {
        this.bucketCountThresholds.setShardSize(shardSize);
        return this;
    }

    public SignificantTermsBuilder minDocCount(int minDocCount) {
        this.bucketCountThresholds.setMinDocCount(minDocCount);
        return this;
    }

    public SignificantTermsBuilder backgroundFilter(QueryBuilder filter) {
        this.filterBuilder = filter;
        return this;
    }

    public SignificantTermsBuilder shardMinDocCount(int shardMinDocCount) {
        this.bucketCountThresholds.setShardMinDocCount(shardMinDocCount);
        return this;
    }

    public SignificantTermsBuilder executionHint(String executionHint) {
        this.executionHint = executionHint;
        return this;
    }

    public SignificantTermsBuilder include(String regex) {
        return this.include(regex, 0);
    }

    public SignificantTermsBuilder include(String regex, int flags) {
        if (this.includeTerms != null) {
            throw new IllegalArgumentException("exclude clause must be an array of strings or a regex, not both");
        }
        this.includePattern = regex;
        this.includeFlags = flags;
        return this;
    }

    public SignificantTermsBuilder include(String[] terms) {
        if (this.includePattern != null) {
            throw new IllegalArgumentException("include clause must be an array of exact values or a regex, not both");
        }
        this.includeTerms = terms;
        return this;
    }

    public SignificantTermsBuilder include(long[] terms) {
        if (this.includePattern != null) {
            throw new IllegalArgumentException("include clause must be an array of exact values or a regex, not both");
        }
        this.includeTerms = this.longsArrToStringArr(terms);
        return this;
    }

    private String[] longsArrToStringArr(long[] terms) {
        String[] termsAsString = new String[terms.length];
        for (int i = 0; i < terms.length; ++i) {
            termsAsString[i] = Long.toString(terms[i]);
        }
        return termsAsString;
    }

    public SignificantTermsBuilder exclude(String regex) {
        return this.exclude(regex, 0);
    }

    public SignificantTermsBuilder exclude(String regex, int flags) {
        if (this.excludeTerms != null) {
            throw new IllegalArgumentException("exclude clause must be an array of strings or a regex, not both");
        }
        this.excludePattern = regex;
        this.excludeFlags = flags;
        return this;
    }

    public SignificantTermsBuilder exclude(String[] terms) {
        if (this.excludePattern != null) {
            throw new IllegalArgumentException("exclude clause must be an array of strings or a regex, not both");
        }
        this.excludeTerms = terms;
        return this;
    }

    public SignificantTermsBuilder exclude(long[] terms) {
        if (this.excludePattern != null) {
            throw new IllegalArgumentException("exclude clause must be an array of longs or a regex, not both");
        }
        this.excludeTerms = this.longsArrToStringArr(terms);
        return this;
    }

    @Override
    protected XContentBuilder internalXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.field != null) {
            builder.field("field", this.field);
        }
        this.bucketCountThresholds.toXContent(builder);
        if (this.executionHint != null) {
            builder.field(AbstractTermsParametersParser.EXECUTION_HINT_FIELD_NAME.getPreferredName(), this.executionHint);
        }
        if (this.includePattern != null) {
            if (this.includeFlags == 0) {
                builder.field("include", this.includePattern);
            } else {
                builder.startObject("include").field("pattern", this.includePattern).field("flags", this.includeFlags).endObject();
            }
        }
        if (this.includeTerms != null) {
            builder.array("include", this.includeTerms);
        }
        if (this.excludePattern != null) {
            if (this.excludeFlags == 0) {
                builder.field("exclude", this.excludePattern);
            } else {
                builder.startObject("exclude").field("pattern", this.excludePattern).field("flags", this.excludeFlags).endObject();
            }
        }
        if (this.excludeTerms != null) {
            builder.array("exclude", this.excludeTerms);
        }
        if (this.filterBuilder != null) {
            builder.field(SignificantTermsParametersParser.BACKGROUND_FILTER.getPreferredName());
            this.filterBuilder.toXContent(builder, params);
        }
        if (this.significanceHeuristicBuilder != null) {
            this.significanceHeuristicBuilder.toXContent(builder, params);
        }
        return builder.endObject();
    }

    public SignificantTermsBuilder significanceHeuristic(SignificanceHeuristicBuilder significanceHeuristicBuilder) {
        this.significanceHeuristicBuilder = significanceHeuristicBuilder;
        return this;
    }
}

