/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.channels.Channel;
import java.nio.channels.FileChannel;
import jnr.posix.FileStat;
import jnr.posix.POSIX;
import org.jruby.util.AbstractFileResource;
import org.jruby.util.JRubyFile;
import org.jruby.util.ResourceException;
import org.jruby.util.io.ModeFlags;

class NullDeviceResource
extends AbstractFileResource {
    private static final JRubyFile file = new JRubyFile("NUL:");
    private final POSIX posix;

    NullDeviceResource(POSIX posix) {
        this.posix = posix;
    }

    @Override
    public String absolutePath() {
        return "NUL:";
    }

    @Override
    public String canonicalPath() {
        return "NUL:";
    }

    @Override
    public long length() {
        return 0L;
    }

    @Override
    public long lastModified() {
        return 0L;
    }

    @Override
    public boolean exists() {
        return true;
    }

    @Override
    public boolean canExecute() {
        return false;
    }

    @Override
    public int errno() {
        return this.posix.errno();
    }

    @Override
    public boolean isFile() {
        return true;
    }

    @Override
    public boolean isDirectory() {
        return false;
    }

    @Override
    public boolean isSymLink() {
        return false;
    }

    @Override
    public boolean canRead() {
        return true;
    }

    @Override
    public boolean canWrite() {
        return true;
    }

    @Override
    public String[] list() {
        return null;
    }

    @Override
    public FileStat stat() {
        return null;
    }

    @Override
    public FileStat lstat() {
        return null;
    }

    public String toString() {
        return "NUL:";
    }

    @Override
    public JRubyFile hackyGetJRubyFile() {
        return file;
    }

    @Override
    InputStream openInputStream() throws IOException {
        return new FileInputStream(file);
    }

    @Override
    public Channel openChannel(ModeFlags flags2, int perm) throws ResourceException {
        return this.createChannel(flags2);
    }

    private Channel createChannel(ModeFlags flags2) throws ResourceException {
        FileChannel fileChannel;
        try {
            if (flags2.isWritable() && !flags2.isReadable()) {
                FileOutputStream fos = new FileOutputStream(file, flags2.isAppendable());
                fileChannel = fos.getChannel();
            } else {
                RandomAccessFile raf = new RandomAccessFile(file, flags2.toJavaModeString());
                fileChannel = raf.getChannel();
            }
        }
        catch (FileNotFoundException fnfe) {
            throw file.exists() ? new ResourceException.PermissionDenied(this.absolutePath()) : new ResourceException.NotFound(this.absolutePath());
        }
        catch (IOException ioe) {
            throw new ResourceException.IOError(ioe);
        }
        return fileChannel;
    }
}

