/*
 * Decompiled with CFR 0.152.
 */
package org.encog.engine.network.activation;

import org.encog.engine.network.activation.ActivationFunction;
import org.encog.mathutil.BoundMath;
import org.encog.util.obj.ActivationUtil;

public class ActivationGaussian
implements ActivationFunction {
    private double[] params = new double[0];
    private static final long serialVersionUID = -7166136514935838114L;

    @Override
    public final ActivationFunction clone() {
        return new ActivationGaussian();
    }

    @Override
    public final boolean hasDerivative() {
        return true;
    }

    @Override
    public final void activationFunction(double[] x, int start, int size) {
        for (int i = start; i < start + size; ++i) {
            x[i] = BoundMath.exp(-Math.pow(2.5 * x[i], 2.0));
        }
    }

    @Override
    public final double derivativeFunction(double b, double a) {
        return Math.exp(Math.pow(2.5 * b, 2.0) * 12.5 * b);
    }

    @Override
    public final String[] getParamNames() {
        String[] result = new String[]{};
        return result;
    }

    @Override
    public final double[] getParams() {
        return this.params;
    }

    @Override
    public final void setParam(int index, double value) {
        this.params[index] = value;
    }

    @Override
    public String getFactoryCode() {
        return ActivationUtil.generateActivationFactory("gauss", this);
    }
}

