/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote;

import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;

public final class Constants {
    public static final String DEFAULT_CHARACTER_ENCODING = "ISO-8859-1";
    public static final String LOCALE_DEFAULT = "en";
    public static final Locale DEFAULT_LOCALE = new Locale("en", "");
    public static final int MAX_NOTES = 32;
    public static final int STAGE_NEW = 0;
    public static final int STAGE_PARSE = 1;
    public static final int STAGE_PREPARE = 2;
    public static final int STAGE_SERVICE = 3;
    public static final int STAGE_ENDINPUT = 4;
    public static final int STAGE_ENDOUTPUT = 5;
    public static final int STAGE_KEEPALIVE = 6;
    public static final int STAGE_ENDED = 7;
    public static final boolean IS_SECURITY_ENABLED = System.getSecurityManager() != null;
    public static final boolean USE_CUSTOM_STATUS_MSG_IN_HEADER = Boolean.valueOf(System.getProperty("org.apache.coyote.USE_CUSTOM_STATUS_MSG_IN_HEADER", "false"));
    public static final int MAX_TRAILER_SIZE = Integer.parseInt(System.getProperty("org.apache.coyote.MAX_TRAILER_SIZE", "8192"));
    public static final int MAX_EXTENSION_SIZE = Integer.parseInt(System.getProperty("org.apache.coyote.MAX_EXTENSION_SIZE", "8192"));
    public static final int MAX_SWALLOW_SIZE = Integer.parseInt(System.getProperty("org.apache.coyote.MAX_SWALLOW_SIZE", "2097152"));
    public static final Set<String> ALLOWED_TRAILER_HEADERS;

    static {
        String commaSeparatedHeaders = System.getProperty("org.apache.coyote.ALLOWED_TRAILER_HEADERS");
        HashSet<String> headerSet = new HashSet<String>();
        if (commaSeparatedHeaders != null) {
            String[] headers;
            for (String header : headers = commaSeparatedHeaders.split(",")) {
                String trimmedHeader = header.trim().toLowerCase(Locale.ENGLISH);
                if (trimmedHeader.length() <= 0) continue;
                headerSet.add(trimmedHeader);
            }
        }
        ALLOWED_TRAILER_HEADERS = Collections.unmodifiableSet(headerSet);
    }
}

