/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.analysis;

import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.miscellaneous.TruncateTokenFilter;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.assistedinject.Assisted;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.analysis.AbstractTokenFilterFactory;
import org.elasticsearch.index.analysis.AnalysisSettingsRequired;
import org.elasticsearch.index.settings.IndexSettingsService;

@AnalysisSettingsRequired
public class TruncateTokenFilterFactory
extends AbstractTokenFilterFactory {
    private final int length;

    @Inject
    public TruncateTokenFilterFactory(Index index, IndexSettingsService indexSettingsService, @Assisted String name, @Assisted Settings settings) {
        super(index, indexSettingsService.getSettings(), name, settings);
        this.length = settings.getAsInt("length", (Integer)-1);
        if (this.length <= 0) {
            throw new IllegalArgumentException("length parameter must be provided");
        }
    }

    @Override
    public TokenStream create(TokenStream tokenStream) {
        return new TruncateTokenFilter(tokenStream, this.length);
    }
}

