/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.cache.StringInterner;
import org.gradle.api.internal.changedetection.state.DefaultVisitedTree;
import org.gradle.api.internal.changedetection.state.FileCollectionSnapshot;
import org.gradle.api.internal.changedetection.state.FileCollectionSnapshotImpl;
import org.gradle.api.internal.changedetection.state.FileCollectionSnapshotter;
import org.gradle.api.internal.changedetection.state.FileSnapshotWithKey;
import org.gradle.api.internal.changedetection.state.FileSnapshotter;
import org.gradle.api.internal.changedetection.state.IncrementalFileSnapshot;
import org.gradle.api.internal.changedetection.state.MissingFileSnapshot;
import org.gradle.api.internal.changedetection.state.TreeSnapshot;
import org.gradle.api.internal.changedetection.state.VisitedTree;
import org.gradle.api.internal.file.BufferedStreamingHasher;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.cache.CacheAccess;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.serialize.Encoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractFileCollectionSnapshotter
implements FileCollectionSnapshotter {
    protected final FileSnapshotter snapshotter;
    protected final StringInterner stringInterner;
    protected final FileResolver fileResolver;
    protected CacheAccess cacheAccess;

    public AbstractFileCollectionSnapshotter(FileSnapshotter snapshotter, CacheAccess cacheAccess, StringInterner stringInterner, FileResolver fileResolver) {
        this.snapshotter = snapshotter;
        this.cacheAccess = cacheAccess;
        this.stringInterner = stringInterner;
        this.fileResolver = fileResolver;
    }

    @Override
    public FileCollectionSnapshot emptySnapshot() {
        return new FileCollectionSnapshotImpl(Collections.<String, IncrementalFileSnapshot>emptyMap());
    }

    @Override
    public FileCollectionSnapshot.PreCheck preCheck(FileCollection files, boolean allowReuse) {
        return new DefaultFileCollectionSnapshotPreCheck(files, allowReuse);
    }

    private Integer calculatePreCheckHash(Collection<VisitedTree> visitedTrees) {
        BufferedStreamingHasher hasher = new BufferedStreamingHasher();
        Encoder encoder = hasher.getEncoder();
        try {
            ArrayList sortedTrees = new ArrayList();
            Collections.sort(sortedTrees, DefaultVisitedTree.VisitedTreeComparator.INSTANCE);
            for (VisitedTree tree : visitedTrees) {
                if (tree.getAbsolutePath() != null) {
                    encoder.writeString((CharSequence)tree.getAbsolutePath());
                }
                if (tree.getPatternSet() != null) {
                    encoder.writeInt(tree.getPatternSet().hashCode());
                }
                encoder.writeInt(tree.getEntries().size());
                encoder.writeInt(tree.calculatePreCheckHash());
            }
            return hasher.checksum();
        }
        catch (IOException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }

    @Override
    public FileCollectionSnapshot snapshot(final FileCollectionSnapshot.PreCheck preCheck) {
        if (preCheck.isEmpty()) {
            return this.emptySnapshot();
        }
        final ArrayList<TreeSnapshot> treeSnapshots = new ArrayList<TreeSnapshot>();
        this.cacheAccess.useCache("Create file snapshot", new Runnable(){

            public void run() {
                ArrayList<VisitedTree> nonShareableTrees = new ArrayList<VisitedTree>();
                for (VisitedTree tree : preCheck.getVisitedTrees()) {
                    if (tree.isShareable()) {
                        treeSnapshots.add(tree.maybeCreateSnapshot(AbstractFileCollectionSnapshotter.this.snapshotter, AbstractFileCollectionSnapshotter.this.stringInterner));
                        continue;
                    }
                    nonShareableTrees.add(tree);
                }
                if (!nonShareableTrees.isEmpty() || !preCheck.getMissingFiles().isEmpty()) {
                    VisitedTree nonShareableTree = AbstractFileCollectionSnapshotter.this.createJoinedTree(nonShareableTrees, preCheck.getMissingFiles());
                    treeSnapshots.add(nonShareableTree.maybeCreateSnapshot(AbstractFileCollectionSnapshotter.this.snapshotter, AbstractFileCollectionSnapshotter.this.stringInterner));
                }
            }
        });
        return new FileCollectionSnapshotImpl(treeSnapshots);
    }

    private Collection<FileSnapshotWithKey> createMissingFileSnapshots(Collection<File> missingFiles) {
        ArrayList<FileSnapshotWithKey> missingFileSnapshots = new ArrayList<FileSnapshotWithKey>();
        for (File missingFile : missingFiles) {
            missingFileSnapshots.add(new FileSnapshotWithKey(this.getInternedAbsolutePath(missingFile), MissingFileSnapshot.getInstance()));
        }
        return missingFileSnapshots;
    }

    abstract VisitedTree createJoinedTree(List<VisitedTree> var1, Collection<File> var2);

    private String getInternedAbsolutePath(File file) {
        return this.stringInterner.intern(file.getAbsolutePath());
    }

    protected abstract void visitFiles(FileCollection var1, List<VisitedTree> var2, List<File> var3, boolean var4);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class DefaultFileCollectionSnapshotPreCheck
    implements FileCollectionSnapshot.PreCheck {
        private final List<VisitedTree> visitedTrees;
        private final List<File> missingFiles;
        private final FileCollection files;
        private Integer hash;

        public DefaultFileCollectionSnapshotPreCheck(FileCollection files, boolean allowReuse) {
            this.files = files;
            this.visitedTrees = Lists.newLinkedList();
            this.missingFiles = Lists.newArrayList();
            AbstractFileCollectionSnapshotter.this.visitFiles(files, this.visitedTrees, this.missingFiles, allowReuse);
        }

        @Override
        public Integer getHash() {
            if (this.hash == null) {
                this.hash = AbstractFileCollectionSnapshotter.this.calculatePreCheckHash(this.visitedTrees);
            }
            return this.hash;
        }

        @Override
        public FileCollection getFiles() {
            return this.files;
        }

        @Override
        public Collection<VisitedTree> getVisitedTrees() {
            return this.visitedTrees;
        }

        @Override
        public Collection<File> getMissingFiles() {
            return this.missingFiles;
        }

        @Override
        public boolean isEmpty() {
            for (VisitedTree tree : this.visitedTrees) {
                if (tree.getEntries().isEmpty()) continue;
                return false;
            }
            return this.missingFiles.isEmpty();
        }
    }
}

