/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.i18n;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.logging.Logger;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Region;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.util.RandomUtils;
import net.sf.freecol.common.util.StringUtils;

public class NameCache {
    private static final Logger logger = Logger.getLogger(NameCache.class.getName());
    private static final String[] DEFAULT_SEASON_IDS = new String[]{"model.season.spring.name", "model.season.autumn.name"};
    private static final String CIBOLA_PREFIX = "nameCache.lostCityRumour.cityName.";
    private static List<String> cibolaKeys = null;
    private static final Object cibolaLock = new Object();
    private static List<String> mercenaryLeaders = null;
    private static final Object mercenaryLock = new Object();
    private static final Map<String, List<String>> regionNames = new HashMap<String, List<String>>();
    private static final Object regionNameLock = new Object();
    private static final Map<String, Integer> regionIndex = new HashMap<String, Integer>();
    private static List<String> riverNames = null;
    private static final Object riverNameLock = new Object();
    private static List<String> seasonNames = null;
    private static final Object seasonNamesLock = new Object();
    private static int seasonNumber = 0;
    private static final Map<Player, String> capitalNames = new HashMap<Player, String>();
    private static final Map<Player, List<String>> settlementNames = new HashMap<Player, List<String>>();
    private static final Object settlementNameLock = new Object();
    private static final Map<Player, List<String>> shipNames = new HashMap<Player, List<String>>();
    private static final Object shipNameLock = new Object();

    private static void collectNames(String prefix, List<String> names) {
        String name = prefix + "0";
        if (Messages.containsKey(name)) {
            names.add(Messages.message(name));
        }
        int i = 1;
        while (Messages.containsKey(name = prefix + Integer.toString(i))) {
            names.add(Messages.message(name));
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void requireCitiesOfCibola(Random random) {
        Object object = cibolaLock;
        synchronized (object) {
            if (cibolaKeys == null) {
                cibolaKeys = new ArrayList<String>();
                NameCache.collectNames(CIBOLA_PREFIX, cibolaKeys);
                int count = cibolaKeys.size();
                cibolaKeys.clear();
                for (int i = 0; i < count; ++i) {
                    cibolaKeys.add(CIBOLA_PREFIX + i);
                }
                RandomUtils.randomShuffle(logger, "Cibola", cibolaKeys, random);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void requireMercenaryLeaders() {
        Object object = mercenaryLock;
        synchronized (object) {
            if (mercenaryLeaders == null) {
                mercenaryLeaders = new ArrayList<String>();
                NameCache.collectNames("nameCache.mercenaries.", mercenaryLeaders);
            }
        }
    }

    private static String makeRegionKey(Player player, Region.RegionType type) {
        return player.getNationId() + ".region." + StringUtils.lastPart(type.getKey(), ".") + ".";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void requireRegionNames(Player player, Region.RegionType type) {
        Object object = regionNameLock;
        synchronized (object) {
            Integer index;
            String prefix = NameCache.makeRegionKey(player, type);
            List<String> names = regionNames.get(prefix);
            if (names == null) {
                names = new ArrayList<String>();
                NameCache.collectNames(prefix, names);
                regionNames.put(prefix, names);
            }
            if ((index = regionIndex.get(prefix)) == null) {
                regionIndex.put(prefix, names.size() + 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void requireRiverNames() {
        Object object = riverNameLock;
        synchronized (object) {
            if (riverNames == null) {
                riverNames = new ArrayList<String>();
                NameCache.collectNames("model.other.region.river.", riverNames);
                Collections.shuffle(riverNames);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int requireSeasonNames() {
        Object object = seasonNamesLock;
        synchronized (object) {
            if (seasonNames == null) {
                seasonNames = new ArrayList<String>();
                NameCache.collectNames("nameCache.season.", seasonNames);
                seasonNumber = seasonNames.size();
                if (seasonNumber < 2) {
                    seasonNames.clear();
                    for (String s : DEFAULT_SEASON_IDS) {
                        seasonNames.add(Messages.message(s));
                    }
                    seasonNumber = seasonNames.size();
                }
            }
            return seasonNumber;
        }
    }

    public static String getSeasonName(int index) {
        NameCache.requireSeasonNames();
        if (index >= 0 && index < seasonNumber) {
            return seasonNames.get(index);
        }
        return Messages.message(StringTemplate.template("nameCache.season.default").addAmount("%number%", index + 1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void requireSettlementNames(Player player, Random random) {
        Object object = settlementNameLock;
        synchronized (object) {
            if (settlementNames.get(player) == null) {
                ArrayList<String> names = new ArrayList<String>();
                NameCache.collectNames(player.getNationId() + ".settlementName.", names);
                if (names.isEmpty()) {
                    NameCache.collectNames(player.getNationId() + ".settlementName." + player.getSpecification().getId() + ".", names);
                }
                if (names.isEmpty()) {
                    NameCache.collectNames(player.getNationId() + ".settlementName.freecol.", names);
                }
                if (player.isIndian()) {
                    capitalNames.put(player, (String)names.remove(0));
                    if (random != null) {
                        RandomUtils.randomShuffle(logger, "Settlement names", names, random);
                    }
                }
                settlementNames.put(player, names);
                logger.fine("Loaded " + names.size() + " settlement names for " + player.getId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void requireShipNames(Player player, Random random) {
        Object object = shipNameLock;
        synchronized (object) {
            List<String> names = shipNames.get(player);
            if (names == null) {
                String prefix = player.getNationId() + ".ship.";
                names = new ArrayList<String>();
                NameCache.collectNames(prefix, names);
                if (random != null) {
                    RandomUtils.randomShuffle(logger, "Ship names", names, random);
                }
                shipNames.put(player, names);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getNextCityOfCibola() {
        Object object = cibolaLock;
        synchronized (object) {
            return cibolaKeys == null || cibolaKeys.isEmpty() ? null : Messages.message(cibolaKeys.remove(0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getCitiesOfCibola() {
        Object object = cibolaLock;
        synchronized (object) {
            return cibolaKeys == null ? Collections.emptyList() : cibolaKeys;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearCitiesOfCibola() {
        Object object = cibolaLock;
        synchronized (object) {
            if (cibolaKeys != null) {
                cibolaKeys.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addCityOfCibola(String key) {
        Object object = cibolaLock;
        synchronized (object) {
            if (cibolaKeys == null) {
                cibolaKeys = new ArrayList<String>();
            }
            cibolaKeys.add(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getMercenaryLeaderIndex(Random random) {
        int n;
        NameCache.requireMercenaryLeaders();
        Object object = mercenaryLock;
        synchronized (object) {
            n = mercenaryLeaders.size();
        }
        return RandomUtils.randomInt(logger, "Mercenary leader", random, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getMercenaryLeaderName(int index) {
        NameCache.requireMercenaryLeaders();
        Object object = mercenaryLock;
        synchronized (object) {
            return mercenaryLeaders.get(index);
        }
    }

    public static String getNewLandName(Player player) {
        return player.getNewLandName() == null ? Messages.message(player.getNationId() + ".newLandName") : player.getNewLandName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getRegionName(Player player, Region region) {
        int index;
        String name;
        if (region.hasName()) {
            return Messages.message(region.getLabel());
        }
        net.sf.freecol.common.model.Map map = player.getGame().getMap();
        String prefix = NameCache.makeRegionKey(player, region.getType());
        NameCache.requireRegionNames(player, region.getType());
        Object object = regionNameLock;
        synchronized (object) {
            List<String> names = regionNames.get(prefix);
            while (!names.isEmpty()) {
                name = names.remove(0);
                if (map.getRegionByName(name) != null) continue;
                return name;
            }
        }
        if (region.getType() == Region.RegionType.RIVER) {
            NameCache.requireRiverNames();
            object = riverNameLock;
            synchronized (object) {
                while (!riverNames.isEmpty()) {
                    name = riverNames.remove(0);
                    if (map.getRegionByName(name) != null) continue;
                    return name;
                }
            }
        }
        object = regionNameLock;
        synchronized (object) {
            index = regionIndex.get(prefix);
        }
        StringTemplate nn = player.getNationLabel();
        do {
            name = Messages.message(StringTemplate.label(" ").addStringTemplate(nn).addNamed(region.getType()).addName(String.valueOf(index)));
            ++index;
        } while (map.getRegionByName(name) != null);
        Object object2 = regionNameLock;
        synchronized (object2) {
            regionIndex.put(prefix, index);
        }
        return name;
    }

    private static String getFallbackSettlementName(Player player) {
        return Messages.message(player.isEuropean() ? "nameCache.base.colony" : "nameCache.base.settlement") + "-";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getCapitalName(Player player, Random random) {
        NameCache.requireSettlementNames(player, random);
        Object object = settlementNameLock;
        synchronized (object) {
            return capitalNames.get(player);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getSettlementName(Player player, Random random) {
        String name;
        NameCache.requireSettlementNames(player, random);
        Game game = player.getGame();
        Object object = settlementNameLock;
        synchronized (object) {
            List<String> names = settlementNames.get(player);
            while (!names.isEmpty()) {
                name = names.remove(0);
                if (game.getSettlementByName(name) != null) continue;
                return name;
            }
        }
        String base = NameCache.getFallbackSettlementName(player);
        int i = player.getSettlements().size() + 1;
        name = null;
        while (game.getSettlementByName(name = base + i++) != null) {
        }
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void putSettlementName(Player player, String name) {
        if (!name.startsWith(NameCache.getFallbackSettlementName(player))) {
            NameCache.requireSettlementNames(player, null);
            Object object = settlementNameLock;
            synchronized (object) {
                List<String> names = settlementNames.get(player);
                names.add(name);
            }
        }
    }

    public static String getTradeRouteName(Player player) {
        String name;
        String base = Messages.message("nameCache.base.tradeRoute");
        if (player.getTradeRouteByName(base) == null) {
            return base;
        }
        int i = 1;
        while (player.getTradeRouteByName(name = base + i++) != null) {
        }
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getUnitName(Player player, UnitType type, Random random) {
        String name;
        if (!type.isNaval()) {
            return null;
        }
        NameCache.requireShipNames(player, random);
        Object object = shipNameLock;
        synchronized (object) {
            List<String> names = shipNames.get(player);
            while (!names.isEmpty()) {
                name = names.remove(0);
                if (player.getUnitByName(name) != null) continue;
                return name;
            }
        }
        String base = Messages.message("nameCache.base.ship") + "-";
        int i = 1;
        while (player.getUnitByName(name = base + i++) != null) {
        }
        return name;
    }
}

