/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.platform.base.internal;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.gradle.platform.base.DependencySpec;
import org.gradle.platform.base.DependencySpecBuilder;
import org.gradle.platform.base.DependencySpecContainer;
import org.gradle.platform.base.ModuleDependencySpecBuilder;
import org.gradle.platform.base.ProjectDependencySpecBuilder;
import org.gradle.platform.base.internal.DefaultModuleDependencySpec;
import org.gradle.platform.base.internal.DefaultProjectDependencySpec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultDependencySpecContainer
implements DependencySpecContainer {
    private final List<DependencySpecBuilder> builders = new LinkedList<DependencySpecBuilder>();

    @Override
    public ProjectDependencySpecBuilder project(String path) {
        return this.projectDependency().project(path);
    }

    @Override
    public ProjectDependencySpecBuilder library(String name) {
        return this.projectDependency().library(name);
    }

    @Override
    public ModuleDependencySpecBuilder module(String moduleIdOrName) {
        return this.moduleDependency().module(moduleIdOrName);
    }

    @Override
    public ModuleDependencySpecBuilder group(String name) {
        return this.moduleDependency().group(name);
    }

    @Override
    public Collection<DependencySpec> getDependencies() {
        if (this.isEmpty()) {
            return Collections.emptySet();
        }
        return this.dependencySpecSet();
    }

    @Override
    public boolean isEmpty() {
        return this.builders.isEmpty();
    }

    private DefaultProjectDependencySpec.Builder projectDependency() {
        return this.add(new DefaultProjectDependencySpec.Builder());
    }

    private DefaultModuleDependencySpec.Builder moduleDependency() {
        return this.add(new DefaultModuleDependencySpec.Builder());
    }

    private <T extends DependencySpecBuilder> T add(T builder) {
        this.builders.add(builder);
        return builder;
    }

    private Set<DependencySpec> dependencySpecSet() {
        ImmutableSet.Builder specs = ImmutableSet.builder();
        for (DependencySpecBuilder specBuilder : this.builders) {
            specs.add((Object)specBuilder.build());
        }
        return specs.build();
    }
}

