/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.testng;

import java.io.Serializable;
import java.util.List;
import java.util.Set;
import org.gradle.api.internal.tasks.testing.filter.DefaultTestFilter;
import org.gradle.api.tasks.testing.testng.TestNGOptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestNGSpec
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String defaultSuiteName;
    private final String defaultTestName;
    private final String parallel;
    private final int threadCount;
    private final String annotations;
    private final boolean javadocAnnotations;
    private final List testResources;
    private final boolean useDefaultListener;
    private final Set<String> includeGroups;
    private final Set<String> excludeGroups;
    private final Set<String> listeners;
    private final Set<String> includedTests;
    private final String configFailurePolicy;
    private final boolean preserveOrder;
    private final boolean groupByInstances;

    public TestNGSpec(TestNGOptions options, DefaultTestFilter filter) {
        this.defaultSuiteName = options.getSuiteName();
        this.defaultTestName = options.getTestName();
        this.parallel = options.getParallel();
        this.threadCount = options.getThreadCount();
        this.annotations = options.getAnnotations();
        this.javadocAnnotations = options.getJavadocAnnotations();
        this.testResources = options.getTestResources();
        this.useDefaultListener = options.getUseDefaultListeners();
        this.includeGroups = options.getIncludeGroups();
        this.excludeGroups = options.getExcludeGroups();
        this.listeners = options.getListeners();
        this.includedTests = filter.getIncludePatterns();
        this.configFailurePolicy = options.getConfigFailurePolicy();
        this.preserveOrder = options.getPreserveOrder();
        this.groupByInstances = options.getGroupByInstances();
    }

    public Set<String> getListeners() {
        return this.listeners;
    }

    public Set<String> getExcludeGroups() {
        return this.excludeGroups;
    }

    public Set<String> getIncludeGroups() {
        return this.includeGroups;
    }

    public boolean getUseDefaultListeners() {
        return this.useDefaultListener;
    }

    public List getTestResources() {
        return this.testResources;
    }

    public boolean getJavadocAnnotations() {
        return this.javadocAnnotations;
    }

    public String getAnnotations() {
        return this.annotations;
    }

    public int getThreadCount() {
        return this.threadCount;
    }

    public String getParallel() {
        return this.parallel;
    }

    public String getDefaultTestName() {
        return this.defaultTestName;
    }

    public String getDefaultSuiteName() {
        return this.defaultSuiteName;
    }

    public Set<String> getIncludedTests() {
        return this.includedTests;
    }

    public String getConfigFailurePolicy() {
        return this.configFailurePolicy;
    }

    public boolean getPreserveOrder() {
        return this.preserveOrder;
    }

    public boolean getGroupByInstances() {
        return this.groupByInstances;
    }
}

