/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.testing.jacoco.plugins;

import com.google.common.util.concurrent.Callables;
import groovy.lang.GroovyObjectSupport;
import java.io.File;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import org.codehaus.plexus.util.StringUtils;
import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.internal.ConventionMapping;
import org.gradle.api.internal.IConventionAware;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.plugins.ReportingBasePlugin;
import org.gradle.api.reporting.Report;
import org.gradle.api.reporting.ReportingExtension;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.testing.Test;
import org.gradle.internal.jacoco.JacocoAgentJar;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.testing.jacoco.plugins.JacocoPluginExtension;
import org.gradle.testing.jacoco.tasks.JacocoBase;
import org.gradle.testing.jacoco.tasks.JacocoMerge;
import org.gradle.testing.jacoco.tasks.JacocoReport;
import org.gradle.testing.jacoco.tasks.JacocoReportsContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Incubating
public class JacocoPlugin
extends GroovyObjectSupport
implements Plugin<ProjectInternal> {
    public static final String AGENT_CONFIGURATION_NAME = "jacocoAgent";
    public static final String ANT_CONFIGURATION_NAME = "jacocoAnt";
    public static final String PLUGIN_EXTENSION_NAME = "jacoco";
    private final Instantiator instantiator;
    private Project project;

    @Inject
    public JacocoPlugin(Instantiator instantiator) {
        this.instantiator = instantiator;
    }

    public void apply(ProjectInternal project) {
        project.getPluginManager().apply(ReportingBasePlugin.class);
        this.project = project;
        this.addJacocoConfigurations();
        JacocoAgentJar agent = (JacocoAgentJar)this.instantiator.newInstance(JacocoAgentJar.class, new Object[]{project});
        JacocoPluginExtension extension = (JacocoPluginExtension)((Object)project.getExtensions().create(PLUGIN_EXTENSION_NAME, JacocoPluginExtension.class, new Object[]{project, agent}));
        final ReportingExtension reportingExtension = (ReportingExtension)project.getExtensions().getByName("reporting");
        ((IConventionAware)extension).getConventionMapping().map("reportsDir", (Callable)new Callable<File>(){

            @Override
            public File call() {
                return reportingExtension.file(JacocoPlugin.PLUGIN_EXTENSION_NAME);
            }
        });
        this.configureAgentDependencies(agent, extension);
        this.configureTaskClasspathDefaults(extension);
        this.applyToDefaultTasks(extension);
        this.configureDefaultOutputPathForJacocoMerge();
        this.configureJacocoReportsDefaults(extension);
        this.addDefaultReportTasks(extension);
    }

    private void addJacocoConfigurations() {
        Configuration agentConf = (Configuration)this.project.getConfigurations().create(AGENT_CONFIGURATION_NAME);
        agentConf.setVisible(false);
        agentConf.setTransitive(true);
        agentConf.setDescription("The Jacoco agent to use to get coverage data.");
        Configuration antConf = (Configuration)this.project.getConfigurations().create(ANT_CONFIGURATION_NAME);
        antConf.setVisible(false);
        antConf.setTransitive(true);
        antConf.setDescription("The Jacoco ant tasks to use to get execute Gradle tasks.");
    }

    private void configureAgentDependencies(JacocoAgentJar jacocoAgentJar, final JacocoPluginExtension extension) {
        Configuration config = this.project.getConfigurations().getAt(AGENT_CONFIGURATION_NAME);
        ((IConventionAware)jacocoAgentJar).getConventionMapping().map("agentConf", Callables.returning((Object)config));
        config.defaultDependencies((Action)new Action<DependencySet>(){

            public void execute(DependencySet dependencies) {
                dependencies.add((Object)JacocoPlugin.this.project.getDependencies().create((Object)("org.jacoco:org.jacoco.agent:" + extension.getToolVersion())));
            }
        });
    }

    private void configureTaskClasspathDefaults(final JacocoPluginExtension extension) {
        final Configuration config = this.project.getConfigurations().getAt(ANT_CONFIGURATION_NAME);
        this.project.getTasks().withType(JacocoBase.class, (Action)new Action<JacocoBase>(){

            public void execute(JacocoBase task) {
                ((IConventionAware)task).getConventionMapping().map("jacocoClasspath", Callables.returning((Object)config));
            }
        });
        config.defaultDependencies((Action)new Action<DependencySet>(){

            public void execute(DependencySet dependencies) {
                dependencies.add((Object)JacocoPlugin.this.project.getDependencies().create((Object)("org.jacoco:org.jacoco.ant:" + extension.getToolVersion())));
            }
        });
    }

    private void applyToDefaultTasks(final JacocoPluginExtension extension) {
        this.project.getTasks().withType(Test.class, (Action)new Action<Test>(){

            public void execute(Test task) {
                extension.applyTo(task);
            }
        });
    }

    public Object configureDefaultOutputPathForJacocoMerge() {
        return this.project.getTasks().withType(JacocoMerge.class, (Action)new Action<JacocoMerge>(){

            public void execute(final JacocoMerge task) {
                ConventionMapping mapping = ((IConventionAware)task).getConventionMapping();
                mapping.map("destinationFile", (Callable)new Callable<File>(){

                    @Override
                    public File call() {
                        return new File(JacocoPlugin.this.project.getBuildDir(), "/jacoco/" + task.getName() + ".exec");
                    }
                });
            }
        });
    }

    private void configureJacocoReportsDefaults(final JacocoPluginExtension extension) {
        this.project.getTasks().withType(JacocoReport.class, (Action)new Action<JacocoReport>(){

            public void execute(JacocoReport reportTask) {
                JacocoPlugin.this.configureJacocoReportDefaults(extension, reportTask);
            }
        });
    }

    private void configureJacocoReportDefaults(final JacocoPluginExtension extension, final JacocoReport reportTask) {
        reportTask.getReports().all((Action)new Action<Report>(){

            public void execute(final Report report) {
                ConventionMapping mapping = ((IConventionAware)report).getConventionMapping();
                mapping.map("enabled", Callables.returning((Object)report.getName().equals("html")));
                if (report.getOutputType().equals((Object)Report.OutputType.DIRECTORY)) {
                    mapping.map("destination", (Callable)new Callable<File>(){

                        @Override
                        public File call() {
                            return new File(extension.getReportsDir(), reportTask.getName() + "/" + report.getName());
                        }
                    });
                } else {
                    mapping.map("destination", (Callable)new Callable<File>(){

                        @Override
                        public File call() {
                            return new File(extension.getReportsDir(), reportTask.getName() + "/" + reportTask.getName() + "." + report.getName());
                        }
                    });
                }
            }
        });
    }

    private void addDefaultReportTasks(final JacocoPluginExtension extension) {
        this.project.getPlugins().withType(JavaPlugin.class, (Action)new Action<JavaPlugin>(){

            public void execute(JavaPlugin javaPlugin) {
                JacocoPlugin.this.project.getTasks().withType(Test.class, (Action)new Action<Test>(){

                    public void execute(Test task) {
                        if (task.getName().equals("test")) {
                            JacocoPlugin.this.addDefaultReportTask(extension, task);
                        }
                    }
                });
            }
        });
    }

    private void addDefaultReportTask(final JacocoPluginExtension extension, final Test task) {
        final JacocoReport reportTask = (JacocoReport)this.project.getTasks().create(PLUGIN_EXTENSION_NAME + StringUtils.capitalise((String)task.getName()) + "Report", JacocoReport.class);
        reportTask.executionData(new Task[]{task});
        reportTask.sourceSets((SourceSet)((JavaPluginConvention)this.project.getConvention().getPlugin(JavaPluginConvention.class)).getSourceSets().getByName("main"));
        ConventionMapping taskMapping = ((IConventionAware)reportTask).getConventionMapping();
        ((JacocoReportsContainer)taskMapping.getConventionValue((Object)reportTask.getReports(), "reports", false)).all((Action)new Action<Report>(){

            public void execute(final Report report) {
                ConventionMapping reportMapping = ((IConventionAware)report).getConventionMapping();
                if (report.getOutputType().equals((Object)Report.OutputType.DIRECTORY)) {
                    reportMapping.map("destination", (Callable)new Callable<File>(){

                        @Override
                        public File call() {
                            return new File(extension.getReportsDir(), task.getName() + "/" + report.getName());
                        }
                    });
                } else {
                    reportMapping.map("destination", (Callable)new Callable<File>(){

                        @Override
                        public File call() {
                            return new File(extension.getReportsDir(), task.getName() + "/" + reportTask.getName() + "." + report.getName());
                        }
                    });
                }
            }
        });
    }

    public static String getAGENT_CONFIGURATION_NAME() {
        return AGENT_CONFIGURATION_NAME;
    }

    public static String getANT_CONFIGURATION_NAME() {
        return ANT_CONFIGURATION_NAME;
    }

    public static String getPLUGIN_EXTENSION_NAME() {
        return PLUGIN_EXTENSION_NAME;
    }
}

