/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.connection;

import java.io.File;
import java.util.concurrent.TimeUnit;
import org.gradle.internal.composite.GradleParticipantBuild;
import org.gradle.tooling.GradleConnector;
import org.gradle.tooling.ProjectConnection;
import org.gradle.tooling.internal.connection.DefaultBuildIdentifier;
import org.gradle.tooling.internal.connection.DefaultProjectIdentifier;
import org.gradle.tooling.internal.consumer.DefaultGradleConnector;
import org.gradle.tooling.model.BuildIdentifier;
import org.gradle.tooling.model.ProjectIdentifier;

class ParticipantConnector {
    private final GradleParticipantBuild build;
    private final File gradleUserHome;
    private final File projectDirectory;
    private final File daemonBaseDir;
    private final Integer daemonMaxIdleTimeValue;
    private final TimeUnit daemonMaxIdleTimeUnits;

    public ParticipantConnector(GradleParticipantBuild build, File gradleUserHome, File daemonBaseDir, Integer daemonMaxIdleTimeValue, TimeUnit daemonMaxIdleTimeUnits) {
        this(build, build.getProjectDir(), gradleUserHome, daemonBaseDir, daemonMaxIdleTimeValue, daemonMaxIdleTimeUnits);
    }

    private ParticipantConnector(GradleParticipantBuild build, File projectDirectory, File gradleUserHome, File daemonBaseDir, Integer daemonMaxIdleTimeValue, TimeUnit daemonMaxIdleTimeUnits) {
        this.build = build;
        this.projectDirectory = projectDirectory;
        this.gradleUserHome = gradleUserHome;
        this.daemonBaseDir = daemonBaseDir;
        this.daemonMaxIdleTimeValue = daemonMaxIdleTimeValue;
        this.daemonMaxIdleTimeUnits = daemonMaxIdleTimeUnits;
    }

    public BuildIdentifier toBuildIdentifier() {
        return new DefaultBuildIdentifier(this.build.getProjectDir());
    }

    public ProjectIdentifier toProjectIdentifier(String projectPath) {
        return new DefaultProjectIdentifier(this.build.getProjectDir(), projectPath);
    }

    public ProjectConnection connect() {
        return this.connector().forProjectDirectory(this.projectDirectory).connect();
    }

    private GradleConnector connector() {
        DefaultGradleConnector connector = (DefaultGradleConnector)GradleConnector.newConnector();
        connector.useGradleUserHomeDir(this.gradleUserHome);
        if (this.daemonBaseDir != null) {
            connector.daemonBaseDir(this.daemonBaseDir);
        }
        if (this.daemonMaxIdleTimeValue != null) {
            connector.daemonMaxIdleTime(this.daemonMaxIdleTimeValue, this.daemonMaxIdleTimeUnits);
        }
        if (this.isRoot()) {
            connector.searchUpwards(false);
        }
        this.configureDistribution(connector);
        return connector;
    }

    private boolean isRoot() {
        return this.build.getProjectDir().equals(this.projectDirectory);
    }

    private void configureDistribution(GradleConnector connector) {
        if (this.build.getGradleDistribution() == null) {
            if (this.build.getGradleHome() == null) {
                if (this.build.getGradleVersion() == null) {
                    connector.useBuildDistribution();
                } else {
                    connector.useGradleVersion(this.build.getGradleVersion());
                }
            } else {
                connector.useInstallation(this.build.getGradleHome());
            }
        } else {
            connector.useDistribution(this.build.getGradleDistribution());
        }
    }
}

