/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.visitors;

import jadx.core.dex.attributes.AFlag;
import jadx.core.dex.attributes.AType;
import jadx.core.dex.attributes.nodes.FieldReplaceAttr;
import jadx.core.dex.info.AccessInfo;
import jadx.core.dex.info.ClassInfo;
import jadx.core.dex.info.FieldInfo;
import jadx.core.dex.info.MethodInfo;
import jadx.core.dex.instructions.IndexInsnNode;
import jadx.core.dex.instructions.InsnType;
import jadx.core.dex.instructions.args.InsnArg;
import jadx.core.dex.instructions.args.RegisterArg;
import jadx.core.dex.instructions.mods.ConstructorInsn;
import jadx.core.dex.nodes.BlockNode;
import jadx.core.dex.nodes.ClassNode;
import jadx.core.dex.nodes.FieldNode;
import jadx.core.dex.nodes.InsnNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.visitors.AbstractVisitor;
import jadx.core.dex.visitors.JadxVisitor;
import jadx.core.dex.visitors.ModVisitor;
import jadx.core.utils.InstructionRemover;
import jadx.core.utils.exceptions.JadxException;
import java.util.List;

@JadxVisitor(name="ClassModifier", desc="Remove synthetic classes, methods and fields", runAfter={ModVisitor.class})
public class ClassModifier
extends AbstractVisitor {
    @Override
    public boolean visit(ClassNode cls) throws JadxException {
        for (ClassNode inner : cls.getInnerClasses()) {
            this.visit(inner);
        }
        if (cls.getAccessFlags().isSynthetic() && cls.getFields().isEmpty() && cls.getMethods().isEmpty()) {
            cls.add(AFlag.DONT_GENERATE);
            return false;
        }
        ClassModifier.removeSyntheticFields(cls);
        ClassModifier.removeSyntheticMethods(cls);
        ClassModifier.removeEmptyMethods(cls);
        ClassModifier.checkFieldsInit(cls);
        this.markAnonymousClass(cls);
        return false;
    }

    private void markAnonymousClass(ClassNode cls) {
        if (cls.isAnonymous()) {
            cls.add(AFlag.ANONYMOUS_CLASS);
        }
    }

    private static void removeSyntheticFields(ClassNode cls) {
        if (!cls.getClassInfo().isInner() || cls.getAccessFlags().isStatic()) {
            return;
        }
        for (FieldNode field : cls.getFields()) {
            if (!field.getAccessFlags().isSynthetic() || !field.getType().isObject()) continue;
            ClassInfo clsInfo = ClassInfo.fromType(cls.dex(), field.getType());
            ClassNode fieldsCls = cls.dex().resolveClass(clsInfo);
            ClassInfo parentClass = cls.getClassInfo().getParentClass();
            if (fieldsCls == null || !parentClass.equals(fieldsCls.getClassInfo()) || !field.getName().startsWith("this$")) continue;
            int found = 0;
            for (MethodNode mth : cls.getMethods()) {
                if (!ClassModifier.removeFieldUsageFromConstructor(mth, field, fieldsCls)) continue;
                ++found;
            }
            if (found == 0) continue;
            FieldInfo replace = FieldInfo.from(cls.dex(), parentClass, "this", parentClass.getType());
            field.addAttr(new FieldReplaceAttr(replace, true));
            field.add(AFlag.DONT_GENERATE);
        }
    }

    private static boolean removeFieldUsageFromConstructor(MethodNode mth, FieldNode field, ClassNode fieldsCls) {
        if (mth.isNoCode() || !mth.getAccessFlags().isConstructor()) {
            return false;
        }
        List<RegisterArg> args = mth.getArguments(false);
        if (args.isEmpty() || mth.contains(AFlag.SKIP_FIRST_ARG)) {
            return false;
        }
        RegisterArg arg = args.get(0);
        if (!arg.getType().equals(fieldsCls.getClassInfo().getType())) {
            return false;
        }
        BlockNode block = mth.getBasicBlocks().get(0);
        List<InsnNode> instructions = block.getInstructions();
        if (instructions.isEmpty()) {
            return false;
        }
        InsnNode insn = instructions.get(0);
        if (insn.getType() != InsnType.IPUT) {
            return false;
        }
        IndexInsnNode putInsn = (IndexInsnNode)insn;
        FieldInfo fieldInfo = (FieldInfo)putInsn.getIndex();
        if (!fieldInfo.equals(field.getFieldInfo()) || !putInsn.getArg(0).equals(arg)) {
            return false;
        }
        mth.removeFirstArgument();
        InstructionRemover.remove(mth, block, insn);
        if (arg.getSVar().getUseCount() != 0) {
            IndexInsnNode iget = new IndexInsnNode(InsnType.IGET, fieldInfo, 1);
            iget.addArg(insn.getArg(1));
            for (InsnArg insnArg : arg.getSVar().getUseList()) {
                insnArg.wrapInstruction(iget);
            }
        }
        return true;
    }

    private static void removeSyntheticMethods(ClassNode cls) {
        for (MethodNode mth : cls.getMethods()) {
            ConstructorInsn constr;
            List<InsnNode> insns;
            if (mth.isNoCode()) continue;
            AccessInfo af = mth.getAccessFlags();
            if (af.isBridge() && af.isSynthetic() && !ClassModifier.isMethodUniq(cls, mth)) {
                mth.add(AFlag.DONT_GENERATE);
                continue;
            }
            if (!af.isSynthetic() || !af.isConstructor() || mth.getBasicBlocks().size() != 2 || (insns = mth.getBasicBlocks().get(0).getInstructions()).size() != 1 || insns.get(0).getType() != InsnType.CONSTRUCTOR || !(constr = (ConstructorInsn)insns.get(0)).isThis() || mth.getArguments(false).isEmpty()) continue;
            mth.removeFirstArgument();
            mth.add(AFlag.DONT_GENERATE);
        }
    }

    private static boolean isMethodUniq(ClassNode cls, MethodNode mth) {
        MethodInfo mi = mth.getMethodInfo();
        for (MethodNode otherMth : cls.getMethods()) {
            MethodInfo omi;
            if (otherMth == mth || !(omi = otherMth.getMethodInfo()).getName().equals(mi.getName()) || omi.getArgumentsTypes().size() != mi.getArgumentsTypes().size()) continue;
            return false;
        }
        return true;
    }

    private static void removeEmptyMethods(ClassNode cls) {
        for (MethodNode mth : cls.getMethods()) {
            List<BlockNode> bb;
            AccessInfo af = mth.getAccessFlags();
            if (!af.isConstructor() || !af.isPublic() || !mth.getArguments(false).isEmpty() || mth.contains(AType.JADX_ERROR) || (bb = mth.getBasicBlocks()) != null && !bb.isEmpty() && !ClassModifier.allBlocksEmpty(bb)) continue;
            mth.add(AFlag.DONT_GENERATE);
        }
    }

    private static boolean allBlocksEmpty(List<BlockNode> blocks) {
        for (BlockNode block : blocks) {
            if (block.getInstructions().isEmpty()) continue;
            return false;
        }
        return true;
    }

    private static void checkFieldsInit(ClassNode cls) {
        MethodNode clinit = cls.searchMethodByName("<clinit>()V");
        if (clinit == null || !clinit.getAccessFlags().isStatic() || clinit.isNoCode()) {
            return;
        }
        for (BlockNode block : clinit.getBasicBlocks()) {
            for (InsnNode insn : block.getInstructions()) {
                if (insn.getType() != InsnType.SPUT) continue;
                ClassModifier.processStaticFieldAssign(cls, (IndexInsnNode)insn);
            }
        }
    }

    private static void processStaticFieldAssign(ClassNode cls, IndexInsnNode insn) {
        FieldNode fn;
        FieldInfo field = (FieldInfo)insn.getIndex();
        String thisClass = cls.getClassInfo().getFullName();
        if (field.getDeclClass().getFullName().equals(thisClass) && (fn = cls.searchField(field)) != null && fn.getAccessFlags().isFinal()) {
            fn.remove(AType.FIELD_VALUE);
        }
    }
}

