/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import java.io.BufferedReader;
import javajs.util.P3;
import org.jmol.jvxl.readers.SurfaceGenerator;
import org.jmol.jvxl.readers.VolumeFileReader;
import org.jmol.util.Logger;
import org.jmol.util.SimpleUnitCell;

abstract class MapFileReader
extends VolumeFileReader {
    protected float dmin = Float.MAX_VALUE;
    protected float dmax;
    protected float dmean;
    protected float drange;
    protected int mapc;
    protected int mapr;
    protected int maps;
    protected int nx;
    protected int ny;
    protected int nz;
    protected int mode;
    protected int[] nxyzStart = new int[3];
    protected int na;
    protected int nb;
    protected int nc;
    protected float a;
    protected float b;
    protected float c;
    protected float alpha;
    protected float beta;
    protected float gamma;
    protected P3 origin = new P3();
    protected P3[] vectors = new P3[3];

    MapFileReader() {
    }

    @Override
    void init2(SurfaceGenerator sg, BufferedReader br) {
        this.init2MFR(sg, br);
    }

    protected void init2MFR(SurfaceGenerator sg, BufferedReader br) {
        this.init2VFR(sg, br);
        this.isAngstroms = true;
    }

    protected void getVectorsAndOrigin() {
        Logger.info("grid parameters: nx,ny,nz: " + this.nx + "," + this.ny + "," + this.nz);
        Logger.info("grid parameters: nxStart,nyStart,nzStart: " + this.nxyzStart[0] + "," + this.nxyzStart[1] + "," + this.nxyzStart[2]);
        Logger.info("grid parameters: mx,my,mz: " + this.na + "," + this.nb + "," + this.nc);
        Logger.info("grid parameters: a,b,c,alpha,beta,gamma: " + this.a + "," + this.b + "," + this.c + "," + this.alpha + "," + this.beta + "," + this.gamma);
        Logger.info("grid parameters: mapc,mapr,maps: " + this.mapc + "," + this.mapr + "," + this.maps);
        Logger.info("grid parameters: originX,Y,Z: " + this.origin);
        SimpleUnitCell unitCell = SimpleUnitCell.newA(new float[]{this.a / (float)this.na, this.b / (float)this.nb, this.c / (float)this.nc, this.alpha, this.beta, this.gamma});
        this.vectors[0] = P3.new3(1.0f, 0.0f, 0.0f);
        this.vectors[1] = P3.new3(0.0f, 1.0f, 0.0f);
        this.vectors[2] = P3.new3(0.0f, 0.0f, 1.0f);
        unitCell.toCartesian(this.vectors[0], false);
        unitCell.toCartesian(this.vectors[1], false);
        unitCell.toCartesian(this.vectors[2], false);
        Logger.info("Jmol unit cell vectors:");
        Logger.info("    a: " + this.vectors[0]);
        Logger.info("    b: " + this.vectors[1]);
        Logger.info("    c: " + this.vectors[2]);
        this.voxelCounts[0] = this.nz;
        this.voxelCounts[1] = this.ny;
        this.voxelCounts[2] = this.nx;
        this.volumetricVectors[0].setT(this.vectors[this.maps - 1]);
        this.volumetricVectors[1].setT(this.vectors[this.mapr - 1]);
        this.volumetricVectors[2].setT(this.vectors[this.mapc - 1]);
        if (this.origin.x == 0.0f && this.origin.y == 0.0f && this.origin.z == 0.0f) {
            int[] xyz2crs = new int[3];
            xyz2crs[this.mapc - 1] = 0;
            xyz2crs[this.mapr - 1] = 1;
            xyz2crs[this.maps - 1] = 2;
            int xIndex = xyz2crs[0];
            int yIndex = xyz2crs[1];
            int zIndex = xyz2crs[2];
            this.origin.scaleAdd2(this.nxyzStart[xIndex], this.vectors[0], this.origin);
            this.origin.scaleAdd2(this.nxyzStart[yIndex], this.vectors[1], this.origin);
            this.origin.scaleAdd2(this.nxyzStart[zIndex], this.vectors[2], this.origin);
        }
        this.volumetricOrigin.setT(this.origin);
        Logger.info("Jmol grid origin in Cartesian coordinates: " + this.origin);
        Logger.info("Use  isosurface OFFSET {x y z}  if you want to shift it.\n");
    }

    protected void setCutoffAutomatic() {
        if (this.params.thePlane == null && this.params.cutoffAutomatic) {
            this.params.cutoff = -1.0f;
            Logger.info("MapReader: setting cutoff to default value of " + this.params.cutoff + (this.boundingBox == null ? " (no BOUNDBOX parameter)\n" : "\n"));
        }
    }
}

