/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.pymol;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.Lst;
import javajs.util.P3;
import javajs.util.PT;
import javajs.util.V3;
import org.jmol.adapter.readers.pdb.PdbReader;
import org.jmol.adapter.readers.pymol.PickleReader;
import org.jmol.adapter.readers.pymol.PyMOL;
import org.jmol.adapter.readers.pymol.PyMOLScene;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.Bond;
import org.jmol.adapter.smarter.Structure;
import org.jmol.api.PymolAtomReader;
import org.jmol.c.STR;
import org.jmol.java.BS;
import org.jmol.util.BSUtil;
import org.jmol.util.BoxInfo;
import org.jmol.util.Logger;

public class PyMOLReader
extends PdbReader
implements PymolAtomReader {
    private static final int MIN_RESNO = -1000;
    private static String nucleic = " A C G T U ADE THY CYT GUA URI DA DC DG DT DU ";
    private boolean allowSurface = true;
    private boolean doResize;
    private boolean doCache;
    private boolean isStateScript;
    private boolean sourcePNGJ;
    private int ac0;
    private int ac;
    private int stateCount;
    private int structureCount;
    private boolean isHidden;
    private BS bsStructureDefined = new BS();
    private BS bsBytesExcluded;
    private int[] atomMap;
    private Map<String, BS> ssMapSeq;
    private PyMOLScene pymolScene;
    private P3 xyzMin = P3.new3(1000000.0f, 1000000.0f, 1000000.0f);
    private P3 xyzMax = P3.new3(-1000000.0f, -1000000.0f, -1000000.0f);
    private int nModels;
    private boolean logging;
    private BS[] reps = new BS[23];
    private boolean isMovie;
    private int pymolFrame;
    private boolean allStates;
    private int totalAtomCount;
    private int pymolVersion;
    private P3[] trajectoryStep;
    private int trajectoryPtr;
    private String objectName;
    private Map<String, Lst<Object>> volumeData;
    private Lst<Lst<Object>> mapObjects;
    private boolean haveMeasurements;
    private int[] frames;
    private Hashtable<Integer, Lst<Object>> uniqueSettings;
    private Atom[] atoms;
    private boolean haveScenes;
    private int baseModelIndex;
    private Lst<Object> sceneOrder;
    private int bondCount;

    @Override
    protected void setup(String fullPath, Map<String, Object> htParams, Object reader) {
        this.mustFinalizeModelSet = true;
        this.isBinary = true;
        this.setupASCR(fullPath, htParams, reader);
    }

    @Override
    protected void initializeReader() throws Exception {
        this.baseAtomIndex = (Integer)this.htParams.get("baseAtomIndex");
        this.baseModelIndex = (Integer)this.htParams.get("baseModelIndex");
        this.asc.setInfo("noAutoBond", Boolean.TRUE);
        this.asc.setCurrentModelInfo("pdbNoHydrogens", Boolean.TRUE);
        this.asc.setInfo("isPyMOL", Boolean.TRUE);
        if (this.isTrajectory) {
            this.trajectorySteps = new Lst();
        }
        this.isStateScript = this.htParams.containsKey("isStateScript");
        this.sourcePNGJ = this.htParams.containsKey("sourcePNGJ");
        this.doResize = this.checkFilterKey("DORESIZE");
        this.allowSurface = !this.checkFilterKey("NOSURFACE");
        this.doCache = this.checkFilterKey("DOCACHE");
        if (this.doCache && this.sourcePNGJ) {
            this.doCache = false;
        } else if (this.sourcePNGJ && !this.doCache) {
            this.sourcePNGJ = false;
        }
        if (this.doCache) {
            this.bsBytesExcluded = new BS();
        }
        super.initializeReader();
    }

    @Override
    public void processBinaryDocument() throws Exception {
        String logFile = this.vwr.getLogFileName();
        this.logging = logFile.length() > 0;
        Logger.info(this.logging ? "PyMOL (1) file data streaming to " + logFile : "To view raw PyMOL file data, use 'set logFile \"some_filename\" ");
        PickleReader reader = new PickleReader(this.binaryDoc, this.vwr);
        Map<String, Object> map = reader.getMap(this.logging && Logger.debuggingHigh);
        reader = null;
        this.process(map);
    }

    @Override
    protected void setAdditionalAtomParameters(Atom atom) {
    }

    @Override
    protected void finalizeSubclassReader() throws Exception {
        this.finalizeReaderPDB();
        this.asc.setTensors();
    }

    @Override
    public void finalizeModelSet() {
        this.pymolScene.setReaderObjects();
        if (this.haveMeasurements) {
            this.appendLoadNote(this.vwr.getMeasurementInfoAsString());
            this.setLoadNote();
        }
        if (this.haveScenes) {
            String[] scenes = new String[this.sceneOrder.size()];
            int i = scenes.length;
            while (--i >= 0) {
                scenes[i] = (String)this.sceneOrder.get(i);
            }
            this.vwr.ms.msInfo.put("scenes", scenes);
        }
        this.vwr.ms.setTrajectoryBs(BSUtil.newBitSet2(this.baseModelIndex, this.vwr.ms.mc));
        if (!this.isStateScript) {
            this.pymolScene.setFrameObject(0, null);
        }
        if (this.bsBytesExcluded != null) {
            int nExcluded = this.bsBytesExcluded.cardinality();
            byte[] bytes0 = (byte[])this.vwr.fm.getFileAsBytes(this.filePath, null);
            byte[] bytes = new byte[bytes0.length - nExcluded];
            int i = this.bsBytesExcluded.nextClearBit(0);
            int n = bytes0.length;
            int pt = 0;
            while (i < n) {
                bytes[pt++] = bytes0[i];
                i = this.bsBytesExcluded.nextClearBit(i + 1);
            }
            bytes0 = null;
            String fileName = this.filePath;
            this.vwr.cachePut(fileName, bytes);
        }
    }

    private void process(Map<String, Object> map) {
        int frameCount;
        Lst<Object> mov;
        String name;
        this.pymolVersion = (Integer)map.get("version");
        this.appendLoadNote("PyMOL version: " + this.pymolVersion);
        Lst<Object> settings = this.fixSettings(PyMOLReader.getMapList(map, "settings"));
        this.sceneOrder = PyMOLReader.getMapList(map, "scene_order");
        this.haveScenes = this.getFrameScenes(map);
        Lst<Object> file = this.listAt(settings, 440);
        if (file != null) {
            Logger.info("PyMOL session file: " + file.get(2));
        }
        this.setUniqueSettings(PyMOLReader.getMapList(map, "unique_settings"));
        this.pymolScene = new PyMOLScene(this, this.vwr, settings, this.uniqueSettings, this.pymolVersion, this.haveScenes, this.baseAtomIndex, this.baseModelIndex, this.doCache, this.filePath);
        String logFile = this.vwr.getLogFileName();
        this.logging = logFile.length() > 0;
        Logger.info(this.logging ? "PyMOL file data streaming to " + logFile : "To view raw PyMOL file data, use 'set logFile \"some_filename\" ");
        Lst<Object> names = PyMOLReader.getMapList(map, "names");
        for (Map.Entry<String, Object> e : map.entrySet()) {
            name = e.getKey();
            Logger.info(name);
            if (!name.equals("names")) continue;
            for (int i = 1; i < names.size(); ++i) {
                Lst<Object> obj = this.listAt(names, i);
                Logger.info("  " + PyMOLReader.stringAt(obj, 0));
            }
        }
        if (this.logging) {
            if (this.logging) {
                this.vwr.log("$CLEAR$");
            }
            for (Map.Entry<String, Object> e : map.entrySet()) {
                name = e.getKey();
                if ("names".equals(name)) continue;
                this.vwr.log("\n===" + name + "===");
                this.vwr.log(PT.rep(e.getValue().toString(), "[", "\n["));
            }
            this.vwr.log("\n===names===");
            for (int i = 1; i < names.size(); ++i) {
                this.vwr.log("");
                Lst list = (Lst)names.get(i);
                this.vwr.log(" =" + list.get(0).toString() + "=");
                try {
                    this.vwr.log(PT.rep(list.toString(), "[", "\n["));
                    continue;
                }
                catch (Throwable name2) {
                    // empty catch block
                }
            }
        }
        this.addColors(PyMOLReader.getMapList(map, "colors"), this.pymolScene.globalSetting(214) != 0.0f);
        this.allStates = this.pymolScene.globalSetting(49) != 0.0f;
        this.pymolFrame = (int)this.pymolScene.globalSetting(194);
        this.getAtomAndStateCount(names);
        this.pymolScene.setStateCount(this.stateCount);
        int pymolState = (int)this.pymolScene.globalSetting(193);
        if (!this.isMovie) {
            this.pymolScene.setFrameObject(4115, this.allStates ? Integer.valueOf(-1) : Integer.valueOf(pymolState - 1));
        }
        this.appendLoadNote("frame=" + this.pymolFrame + " state=" + pymolState + " all_states=" + this.allStates);
        if (!this.isStateScript && this.doResize) {
            String note;
            int width = 0;
            int height = 0;
            Lst<Object> main = PyMOLReader.getMapList(map, "main");
            if (main != null) {
                width = PyMOLReader.intAt(main, 0);
                height = PyMOLReader.intAt(main, 1);
            }
            if (width > 0 && height > 0) {
                note = "PyMOL dimensions width=" + width + " height=" + height;
                this.asc.setInfo("preferredWidthHeight", new int[]{width, height});
                this.vwr.resizeInnerPanel(width, height);
            } else {
                note = "PyMOL dimensions?";
            }
            this.appendLoadNote(note);
        }
        if (!this.isStateScript && !this.allStates && (mov = PyMOLReader.getMapList(map, "movie")) != null && (frameCount = PyMOLReader.intAt(mov, 0)) > 0) {
            this.processMovie(mov, frameCount);
        }
        if (this.totalAtomCount == 0) {
            this.asc.newAtomSet();
        }
        if (!this.allStates || this.desiredModelNumber != Integer.MIN_VALUE) {
            if (this.isMovie) {
                switch (this.desiredModelNumber) {
                    case -2147483648: {
                        break;
                    }
                    default: {
                        this.desiredModelNumber = this.frames[(this.desiredModelNumber > 0 && this.desiredModelNumber <= this.frames.length ? this.desiredModelNumber : this.pymolFrame) - 1];
                        this.pymolScene.setFrameObject(4115, this.desiredModelNumber - 1);
                        break;
                    }
                }
            } else if (this.desiredModelNumber == 0) {
                this.desiredModelNumber = pymolState;
            }
        }
        int n = names.size();
        for (int j = 0; j < this.stateCount; ++j) {
            if (!this.doGetModel(++this.nModels, null)) continue;
            this.model(this.nModels);
            this.pymolScene.currentAtomSetIndex = this.asc.iSet;
            if (this.isTrajectory) {
                this.trajectoryStep = new P3[this.totalAtomCount];
                this.trajectorySteps.addLast(this.trajectoryStep);
                this.trajectoryPtr = 0;
            }
            for (int i = 1; i < n; ++i) {
                this.processObject(this.listAt(names, i), true, j);
            }
        }
        for (int i = 1; i < n; ++i) {
            this.processObject(this.listAt(names, i), false, 0);
        }
        this.pymolScene.setReaderObjectInfo(null, 0, null, false, null, null, null);
        if (this.mapObjects != null && this.allowSurface) {
            this.processMeshes();
        }
        if (this.isTrajectory) {
            this.appendLoadNote("PyMOL trajectories read: " + this.trajectorySteps.size());
            this.asc.finalizeTrajectoryAs(this.trajectorySteps, null);
        }
        this.processDefinitions();
        this.processSelectionsAndScenes(map);
        this.pymolScene.finalizeVisibility();
        if (!this.isStateScript) {
            this.vwr.initialize(false);
            this.addJmolScript(this.pymolScene.getViewScript(PyMOLReader.getMapList(map, "view")).toString());
        }
        if (this.ac == 0) {
            this.asc.setInfo("dataOnly", Boolean.TRUE);
        }
        this.pymolScene.offsetObjects();
    }

    private Lst<Object> fixSettings(Lst<Object> settings) {
        int n = settings.size();
        for (int i = 0; i < n; ++i) {
            int i2 = PyMOLReader.intAt((Lst)settings.get(i), 0);
            if (i2 == -1) {
                Logger.info("PyMOL reader adding null setting #" + i);
                settings.set(i, new Lst());
                continue;
            }
            while (i < i2) {
                Logger.info("PyMOL reader adding null setting #" + i);
                settings.add(i++, new Lst());
                ++n;
            }
        }
        return settings;
    }

    private boolean getFrameScenes(Map<String, Object> map) {
        if (this.sceneOrder == null) {
            return false;
        }
        Map scenes = (Map)map.get("scene_dict");
        for (int i = 0; i < this.sceneOrder.size(); ++i) {
            String name = PyMOLReader.stringAt(this.sceneOrder, i);
            Lst<Object> thisScene = PyMOLReader.getMapList(scenes, name);
            if (thisScene != null && thisScene.get(2) != null) continue;
            this.sceneOrder.remove(i--);
        }
        return this.sceneOrder != null && this.sceneOrder.size() != 0;
    }

    private int setUniqueSettings(Lst<Object> list) {
        this.uniqueSettings = new Hashtable();
        int max = 0;
        if (list != null && list.size() != 0) {
            int i = list.size();
            while (--i >= 0) {
                Lst atomSettings = (Lst)list.get(i);
                int id = PyMOLReader.intAt(atomSettings, 0);
                if (id > max) {
                    max = id;
                }
                Lst mySettings = (Lst)atomSettings.get(1);
                int j = mySettings.size();
                while (--j >= 0) {
                    Lst setting = (Lst)mySettings.get(j);
                    int uid = (id << 10) + PyMOLReader.intAt(setting, 0);
                    this.uniqueSettings.put(uid, setting);
                }
            }
        }
        return max;
    }

    private void addColors(Lst<Object> colors, boolean isClamped) {
        if (colors == null || colors.size() == 0) {
            return;
        }
        int i = colors.size();
        while (--i >= 0) {
            Lst<Object> c = this.listAt(colors, i);
            PyMOL.addColor((Integer)c.get(1), isClamped ? PyMOLScene.colorSettingClamped(c) : PyMOLScene.getColorPt(c.get(2)));
        }
    }

    private void getAtomAndStateCount(Lst<Object> names) {
        int n = 0;
        for (int i = 1; i < names.size(); ++i) {
            Lst<Object> execObject = this.listAt(names, i);
            int type = PyMOLReader.intAt(execObject, 4);
            if (!this.checkObject(execObject) || type != 1) continue;
            Lst<Object> pymolObject = this.listAt(execObject, 5);
            Lst<Object> states = this.listAt(pymolObject, 4);
            int ns = states.size();
            if (ns > this.stateCount) {
                this.stateCount = ns;
            }
            int nAtoms = this.listAt(pymolObject, 7).size();
            for (int j = 0; j < ns; ++j) {
                Lst<Object> state = this.listAt(states, j);
                Lst<Object> idxToAtm = this.listAt(state, 3);
                if (idxToAtm == null) {
                    this.isTrajectory = false;
                    continue;
                }
                int m = idxToAtm.size();
                n += m;
                if (!this.isTrajectory || m == nAtoms) continue;
                this.isTrajectory = false;
            }
        }
        this.totalAtomCount = n;
        Logger.info("PyMOL total atom count = " + this.totalAtomCount);
        Logger.info("PyMOL state count = " + this.stateCount);
    }

    private boolean checkObject(Lst<Object> execObject) {
        this.objectName = PyMOLReader.stringAt(execObject, 0);
        this.isHidden = PyMOLReader.intAt(execObject, 2) != 1;
        return this.objectName.indexOf("_") != 0;
    }

    private void processMovie(Lst<Object> mov, int frameCount) {
        Hashtable<String, Object> movie = new Hashtable<String, Object>();
        movie.put("frameCount", frameCount);
        movie.put("currentFrame", this.pymolFrame - 1);
        boolean haveCommands = false;
        boolean haveViews = false;
        boolean haveFrames = false;
        Lst<Object> list = this.listAt(mov, 4);
        int i = list.size();
        while (--i >= 0) {
            if (PyMOLReader.intAt(list, i) == 0) continue;
            this.frames = new int[list.size()];
            int j = this.frames.length;
            while (--j >= 0) {
                this.frames[j] = PyMOLReader.intAt(list, j) + 1;
            }
            movie.put("frames", this.frames);
            haveFrames = true;
            break;
        }
        Lst<Object> cmds = this.listAt(mov, 5);
        int i2 = cmds.size();
        while (--i2 >= 0) {
            String cmd = PyMOLReader.stringAt(cmds, i2);
            if (cmd == null || cmd.length() <= 1 || (cmds = PyMOLReader.fixMovieCommands(cmds)) == null) continue;
            movie.put("commands", cmds);
            haveCommands = true;
            break;
        }
        Lst<Object> views = this.listAt(mov, 6);
        int i3 = views.size();
        while (--i3 >= 0) {
            Lst<Object> view = this.listAt(views, i3);
            if (view == null || view.size() < 12 || view.get(1) == null) continue;
            haveViews = true;
            if ((views = PyMOLReader.fixMovieViews(views)) == null) continue;
            movie.put("views", views);
            break;
        }
        this.appendLoadNote("PyMOL movie frameCount = " + frameCount);
        if (haveFrames && !haveCommands && !haveViews) {
            this.isMovie = true;
            this.pymolScene.setReaderObjectInfo(null, 0, null, false, null, null, null);
            this.pymolScene.setFrameObject(0x400000D0, movie);
        }
    }

    private static Lst<Object> fixMovieViews(Lst<Object> views) {
        return views;
    }

    private static Lst<Object> fixMovieCommands(Lst<Object> cmds) {
        return cmds;
    }

    private void processObject(Lst<Object> execObject, boolean moleculeOnly, int iState) {
        String parentGroupName;
        if (execObject == null) {
            return;
        }
        int type = PyMOLReader.intAt(execObject, 4);
        Lst startLen = (Lst)execObject.get(execObject.size() - 1);
        if (type == 1 != moleculeOnly || !this.checkObject(execObject)) {
            return;
        }
        Lst<Object> pymolObject = this.listAt(execObject, 5);
        Lst<Object> stateSettings = null;
        if (type == 1) {
            Lst<Object> states = this.listAt(pymolObject, 4);
            Lst<Object> state = this.listAt(states, iState);
            Lst<Object> idxToAtm = this.listAt(state, 3);
            if (iState > 0 && (idxToAtm == null || idxToAtm.size() == 0)) {
                return;
            }
            stateSettings = this.listAt(state, 7);
        } else if (iState > 0) {
            return;
        }
        Logger.info("PyMOL model " + this.nModels + " Object " + this.objectName + (this.isHidden ? " (hidden)" : " (visible)"));
        if (!(this.isHidden || this.isMovie || this.allStates || this.pymolFrame <= 0 || this.pymolFrame == this.nModels)) {
            this.pymolFrame = this.nModels;
            this.allStates = true;
            this.pymolScene.setFrameObject(4115, -1);
        }
        Lst<Object> objectHeader = this.listAt(pymolObject, 0);
        String string = parentGroupName = execObject.size() < 8 ? null : PyMOLReader.stringAt(execObject, 6);
        if (" ".equals(parentGroupName)) {
            parentGroupName = null;
        }
        this.pymolScene.setReaderObjectInfo(this.objectName, type, parentGroupName, this.isHidden, this.listAt(objectHeader, 8), stateSettings, moleculeOnly ? "_" + (iState + 1) : "");
        BS bsAtoms = null;
        boolean doExclude = this.bsBytesExcluded != null;
        String msg = null;
        switch (type) {
            default: {
                msg = "" + type;
                break;
            }
            case -1: {
                this.pymolScene.processSelection(execObject);
                break;
            }
            case 1: {
                doExclude = false;
                bsAtoms = this.processMolecule(pymolObject, iState);
                break;
            }
            case 4: {
                doExclude = false;
                this.processMeasure(pymolObject);
                break;
            }
            case 2: 
            case 3: {
                this.processMap(pymolObject, type == 3, false);
                break;
            }
            case 8: {
                this.processGadget(pymolObject);
                break;
            }
            case 12: {
                if (parentGroupName != null) break;
                parentGroupName = "";
                break;
            }
            case 6: {
                msg = "CGO";
                this.processCGO(pymolObject);
                break;
            }
            case 11: {
                msg = "ALIGNEMENT";
                break;
            }
            case 9: {
                msg = "CALCULATOR";
                break;
            }
            case 5: {
                msg = "CALLBACK";
                break;
            }
            case 10: {
                msg = "SLICE";
                break;
            }
            case 7: {
                msg = "SURFACE";
            }
        }
        if (parentGroupName != null || bsAtoms != null) {
            this.pymolScene.addGroup(execObject, parentGroupName, type, bsAtoms);
        }
        if (doExclude) {
            int i0 = PyMOLReader.intAt(startLen, 0);
            int len = PyMOLReader.intAt(startLen, 1);
            this.bsBytesExcluded.setBits(i0, i0 + len);
            Logger.info("cached PSE file excludes PyMOL object type " + type + " name=" + this.objectName + " len=" + len);
        }
        if (msg != null) {
            Logger.error("Unprocessed object type " + msg + " " + this.objectName);
        }
    }

    private void processCGO(Lst<Object> pymolObject) {
        int color;
        if (this.isStateScript) {
            return;
        }
        if (this.isHidden) {
            return;
        }
        Lst<Object> data = this.listAt(this.listAt(pymolObject, 2), 0);
        String name = this.pymolScene.addCGO(data, color = PyMOL.getRGB(PyMOLReader.intAt(this.listAt(pymolObject, 0), 2)));
        if (name != null) {
            this.appendLoadNote("CGO " + name);
        }
    }

    private void processGadget(Lst<Object> pymolObject) {
        if (this.objectName.endsWith("_e_pot")) {
            this.processMap(pymolObject, true, true);
        }
    }

    private void processMap(Lst<Object> pymolObject, boolean isObject, boolean isGadget) {
        if (isObject) {
            if (this.sourcePNGJ) {
                return;
            }
            if (this.isHidden && !isGadget) {
                return;
            }
            if (this.mapObjects == null) {
                this.mapObjects = new Lst();
            }
            this.mapObjects.addLast(pymolObject);
        } else {
            if (this.volumeData == null) {
                this.volumeData = new Hashtable<String, Lst<Object>>();
            }
            this.volumeData.put(this.objectName, pymolObject);
            if (!this.isHidden && !this.isStateScript) {
                this.pymolScene.addIsosurface(this.objectName);
            }
        }
        pymolObject.addLast(this.objectName);
    }

    private void processMeasure(Lst<Object> pymolObject) {
        int nCoord;
        int n;
        if (this.isStateScript) {
            return;
        }
        if (this.isHidden) {
            return;
        }
        Logger.info("PyMOL measure " + this.objectName);
        Lst<Object> measure = this.listAt(this.listAt(pymolObject, 2), 0);
        int pt = 1;
        if (measure.get(1) instanceof Lst) {
            n = 2;
        } else {
            pt = 4;
            if (measure.get(4) instanceof Lst) {
                n = 3;
            } else {
                pt = 6;
                n = nCoord = measure.get(6) instanceof Lst ? 4 : 0;
            }
        }
        if (nCoord == 0) {
            return;
        }
        Lst<Object> setting = this.listAt(pymolObject, 0);
        BS bsReps = PyMOLReader.getBsReps(this.listAt(setting, 3));
        Lst<Object> list = this.listAt(measure, pt);
        Lst<Object> offsets = this.listAt(measure, 8);
        boolean haveLabels = measure.size() > 8;
        int color = PyMOLReader.intAt(setting, 2);
        if (this.pymolScene.addMeasurements(null, nCoord, list, bsReps, color, offsets, haveLabels)) {
            this.haveMeasurements = true;
        }
    }

    private BS processMolecule(Lst<Object> pymolObject, int iState) {
        int n;
        Lst<Object> states = this.listAt(pymolObject, 4);
        Lst<Object> state = this.listAt(states, iState);
        Lst<Object> idxToAtm = this.listAt(state, 3);
        int n2 = n = idxToAtm == null ? 0 : idxToAtm.size();
        if (n == 0) {
            return null;
        }
        this.ac = this.ac0 = this.asc.ac;
        int nAtoms = PyMOLReader.intAt(pymolObject, 3);
        if (nAtoms == 0) {
            return null;
        }
        this.ssMapSeq = new Hashtable<String, BS>();
        if (iState == 0) {
            this.processMolCryst(this.listAt(pymolObject, 10));
        }
        Lst<Bond> bonds = this.getBondList(this.listAt(pymolObject, 6));
        Lst<Object> pymolAtoms = this.listAt(pymolObject, 7);
        this.atomMap = new int[nAtoms];
        BS bsAtoms = this.pymolScene.setAtomMap(this.atomMap, this.ac0);
        for (int i = 0; i < 23; ++i) {
            this.reps[i] = BS.newN(1000);
        }
        Lst<Object> coords = this.listAt(state, 2);
        Lst<Object> labelPositions = this.listAt(state, 8);
        if (iState == 0 || !this.isTrajectory) {
            this.pymolScene.ensureCapacity(n);
            for (int idx = 0; idx < n; ++idx) {
                P3 a = this.addAtom(pymolAtoms, PyMOLReader.intAt(idxToAtm, idx), idx, coords, labelPositions, bsAtoms, iState);
                if (a == null) continue;
                this.trajectoryStep[this.trajectoryPtr++] = a;
            }
        }
        this.addBonds(bonds);
        this.addMolStructures();
        this.atoms = this.asc.atoms;
        if (!this.isStateScript) {
            this.createShapeObjects();
        }
        this.ssMapSeq = null;
        Logger.info("reading " + (this.ac - this.ac0) + " atoms");
        Logger.info("----------");
        return bsAtoms;
    }

    private void processMolCryst(Lst<Object> cryst) {
        if (cryst == null || cryst.size() == 0) {
            return;
        }
        Lst<Object> l = this.listAt(this.listAt(cryst, 0), 0);
        Lst<Object> a = this.listAt(this.listAt(cryst, 0), 1);
        this.setUnitCell(this.floatAt(l, 0), this.floatAt(l, 1), this.floatAt(l, 2), this.floatAt(a, 0), this.floatAt(a, 1), this.floatAt(a, 2));
        this.setSpaceGroupName(PyMOLReader.stringAt(cryst, 1));
    }

    private Lst<Bond> getBondList(Lst<Object> bonds) {
        boolean asSingle = this.pymolScene.booleanSetting(64);
        int n = bonds.size();
        Lst<Bond> bondList = new Lst<Bond>();
        bondList.ensureCapacity(n);
        for (int i = 0; i < n; ++i) {
            Lst<Object> b = this.listAt(bonds, i);
            int ia = PyMOLReader.intAt(b, 0);
            int ib = PyMOLReader.intAt(b, 1);
            int order = PyMOLReader.intAt(b, 2);
            if (order < 1 || order > 3) {
                order = 1;
            }
            Bond bond = new Bond(ia, ib, order |= asSingle || order == 1 ? 65536 : 98304);
            bond.uniqueID = b.size() > 6 && PyMOLReader.intAt(b, 6) != 0 ? PyMOLReader.intAt(b, 5) : -1;
            bondList.addLast(bond);
        }
        return bondList;
    }

    private P3 addAtom(Lst<Object> pymolAtoms, int apt, int icoord, Lst<Object> coords, Lst<Object> labelPositions, BS bsState, int iState) {
        float[] data;
        boolean isNucleic;
        String sym;
        this.atomMap[apt] = -1;
        Lst<Object> a = this.listAt(pymolAtoms, apt);
        int seqNo = PyMOLReader.intAt(a, 0);
        String chainID = PyMOLReader.stringAt(a, 1);
        String altLoc = PyMOLReader.stringAt(a, 2);
        String insCode = " ";
        String name = PyMOLReader.stringAt(a, 6);
        String group3 = PyMOLReader.stringAt(a, 5);
        if (group3.length() > 3) {
            group3 = group3.substring(0, 3);
        }
        if (group3.equals(" ")) {
            group3 = "UNK";
        }
        if ((sym = PyMOLReader.stringAt(a, 7)).equals("A")) {
            sym = "C";
        }
        boolean isHetero = PyMOLReader.intAt(a, 19) != 0;
        int ichain = this.vwr.getChainID(chainID, true);
        Atom atom = this.processAtom(new Atom(), name, altLoc.charAt(0), group3, ichain, seqNo, insCode.charAt(0), isHetero, sym);
        if (!this.filterPDBAtom(atom, this.fileAtomIndex++)) {
            return null;
        }
        float x = this.floatAt(coords, icoord *= 3);
        float y = this.floatAt(coords, ++icoord);
        float z = this.floatAt(coords, ++icoord);
        BoxInfo.addPointXYZ(x, y, z, this.xyzMin, this.xyzMax, 0.0f);
        if (this.isTrajectory && iState > 0) {
            return null;
        }
        boolean bl = isNucleic = nucleic.indexOf(group3) >= 0;
        if (bsState != null) {
            bsState.set(this.ac);
        }
        String label = PyMOLReader.stringAt(a, 9);
        String ssType = PyMOLReader.stringAt(a, 10).substring(0, 1);
        if (seqNo >= -1000 && (!ssType.equals(" ") || name.equals("CA") || isNucleic)) {
            BS bs = this.ssMapSeq.get(ssType);
            if (bs == null) {
                bs = new BS();
                this.ssMapSeq.put(ssType, bs);
            }
            bs.set(seqNo - -1000);
            ssType = ssType + ichain;
            bs = this.ssMapSeq.get(ssType);
            if (bs == null) {
                bs = new BS();
                this.ssMapSeq.put(ssType, bs);
            }
            bs.set(seqNo - -1000);
        }
        atom.bfactor = this.floatAt(a, 14);
        atom.foccupancy = this.floatAt(a, 15);
        atom.radius = this.floatAt(a, 16);
        if (atom.radius == 0.0f) {
            atom.radius = 1.0f;
        }
        atom.partialCharge = this.floatAt(a, 17);
        int formalCharge = PyMOLReader.intAt(a, 18);
        BS bsReps = PyMOLReader.getBsReps(this.listAt(a, 20));
        int intReps = bsReps == null ? PyMOLReader.intAt(a, 20) : 0;
        int atomColor = PyMOLReader.intAt(a, 21);
        int serNo = PyMOLReader.intAt(a, 22);
        int cartoonType = PyMOLReader.intAt(a, 23);
        int flags = PyMOLReader.intAt(a, 24);
        boolean bonded = PyMOLReader.intAt(a, 25) != 0;
        int uniqueID = a.size() > 40 && PyMOLReader.intAt(a, 40) == 1 ? PyMOLReader.intAt(a, 32) : -1;
        atom.vib = V3.new3(uniqueID, cartoonType, Float.NaN);
        if (a.size() > 46 && (data = PyMOLScene.floatsAt(a, 41, new float[8], 6))[0] != 0.0f) {
            this.asc.setAnisoBorU(atom, data, 12);
        }
        this.pymolScene.setAtomColor(atomColor);
        this.processAtom2(atom, serNo, x, y, z, formalCharge);
        if (!bonded) {
            this.pymolScene.bsNonbonded.set(this.ac);
        }
        if (!label.equals(" ")) {
            this.pymolScene.bsLabeled.set(this.ac);
            Lst<Object> labelOffset = this.listAt(labelPositions, apt);
            this.pymolScene.addLabel(this.ac, uniqueID, atomColor, labelOffset, label);
        }
        if (this.isHidden) {
            this.pymolScene.bsHidden.set(this.ac);
        }
        if (isNucleic) {
            this.pymolScene.bsNucleic.set(this.ac);
        }
        for (int i = 0; i < 21; ++i) {
            if (!(bsReps == null ? (intReps & 1 << i) != 0 : bsReps.get(i))) continue;
            this.reps[i].set(this.ac);
        }
        if (atom.elementSymbol.equals("H")) {
            this.pymolScene.bsHydrogen.set(this.ac);
        }
        if ((flags & PyMOL.FLAG_NOSURFACE) != 0) {
            this.pymolScene.bsNoSurface.set(this.ac);
        }
        ++this.ac;
        return null;
    }

    private void addBonds(Lst<Bond> bonds) {
        int n = bonds.size();
        for (int i = 0; i < n; ++i) {
            Bond bond = (Bond)bonds.get(i);
            bond.atomIndex1 = this.atomMap[bond.atomIndex1];
            bond.atomIndex2 = this.atomMap[bond.atomIndex2];
            if (bond.atomIndex1 < 0 || bond.atomIndex2 < 0) continue;
            this.pymolScene.setUniqueBond(this.bondCount++, bond.uniqueID);
            this.asc.addBond(bond);
        }
    }

    private void addMolStructures() {
        this.addMolSS("H", STR.HELIX);
        this.addMolSS("S", STR.SHEET);
        this.addMolSS("L", STR.TURN);
        this.addMolSS(" ", STR.NONE);
    }

    private void addMolSS(String ssType, STR type) {
        if (this.ssMapSeq.get(ssType) == null) {
            return;
        }
        int istart = -1;
        int iend = -1;
        int ichain = 0;
        Atom[] atoms = this.asc.atoms;
        BS bsSeq = null;
        BS bsAtom = this.pymolScene.getSSMapAtom(ssType);
        int n = this.ac + 1;
        int seqNo = -1;
        int thischain = 0;
        int imodel = -1;
        int thisModel = -1;
        for (int i = this.ac0; i < n; ++i) {
            if (i == this.ac) {
                thischain = 0;
            } else {
                seqNo = atoms[i].sequenceNumber;
                thischain = atoms[i].chainID;
                thisModel = atoms[i].atomSetIndex;
            }
            if (thischain != ichain || thisModel != imodel) {
                ichain = thischain;
                imodel = thisModel;
                bsSeq = this.ssMapSeq.get(ssType + thischain);
                --i;
                if (istart < 0) {
                    continue;
                }
            } else {
                if (bsSeq != null && seqNo >= -1000 && bsSeq.get(seqNo - -1000)) {
                    iend = i;
                    if (istart >= 0) continue;
                    istart = i;
                    continue;
                }
                if (istart < 0) continue;
            }
            if (type != STR.NONE) {
                int pt = this.bsStructureDefined.nextSetBit(istart);
                if (pt >= 0 && pt <= iend) continue;
                this.bsStructureDefined.setBits(istart, iend + 1);
                Structure structure = new Structure(imodel, type, type, type.toString(), ++this.structureCount, type == STR.SHEET ? 1 : 0, null);
                Atom a = atoms[istart];
                Atom b = atoms[iend];
                int i0 = this.asc.getAtomSetAtomIndex(thisModel);
                structure.set(a.chainID, a.sequenceNumber, a.insertionCode, b.chainID, b.sequenceNumber, b.insertionCode, istart - i0, iend - i0);
                this.asc.addStructure(structure);
            }
            bsAtom.setBits(istart, iend + 1);
            istart = -1;
        }
    }

    private void createShapeObjects() {
        this.pymolScene.createShapeObjects(this.reps, this.allowSurface && !this.isHidden, this.ac0, this.ac);
    }

    private void processMeshes() {
        String fileName = this.vwr.fm.getFilePath(this.pymolScene.surfaceInfoName, true, false);
        this.vwr.cachePut(fileName, this.volumeData);
        int i = this.mapObjects.size();
        while (--i >= 0) {
            String mapName;
            int tok;
            Lst obj = (Lst)this.mapObjects.get(i);
            String objName = obj.get(obj.size() - 1).toString();
            boolean isMep = objName.endsWith("_e_pot");
            if (isMep) {
                tok = 0x400000C0;
                String root = objName.substring(0, objName.length() - 3);
                mapName = root + "map";
                String isosurfaceName = this.pymolScene.getObjectID(root + "chg");
                if (isosurfaceName == null) continue;
                obj.addLast(isosurfaceName);
                this.pymolScene.mepList = this.pymolScene.mepList + ";" + isosurfaceName + ";";
            } else {
                tok = 1073742018;
                mapName = PyMOLReader.stringAt(this.listAt(this.listAt(obj, 2), 0), 1);
            }
            Lst<Object> surface = this.volumeData.get(mapName);
            if (surface == null) continue;
            obj.addLast(mapName);
            this.volumeData.put(objName, obj);
            this.volumeData.put("__pymolSurfaceData__", obj);
            if (!this.isStateScript) {
                this.pymolScene.addMesh(tok, obj, objName, isMep);
            }
            this.appendLoadNote("PyMOL object " + objName + " references map " + mapName);
        }
    }

    private void processDefinitions() {
        String s = this.vwr.getAtomDefs(this.pymolScene.setAtomDefs());
        if (s.length() > 2) {
            s = s.substring(0, s.length() - 2);
        }
        this.appendLoadNote(s);
    }

    private void processSelectionsAndScenes(Map<String, Object> map) {
        if (!this.pymolScene.needSelections()) {
            return;
        }
        Map<String, Lst<Object>> htObjNames = PyMOLScene.listToMap(PyMOLReader.getMapList(map, "names"));
        if (this.haveScenes) {
            Map scenes = (Map)map.get("scene_dict");
            this.finalizeSceneData();
            Map<String, Lst<Object>> htSecrets = PyMOLScene.listToMap(PyMOLReader.getMapList(map, "selector_secrets"));
            for (int i = 0; i < this.sceneOrder.size(); ++i) {
                String name = PyMOLReader.stringAt(this.sceneOrder, i);
                Lst<Object> thisScene = PyMOLReader.getMapList(scenes, name);
                if (thisScene == null) continue;
                this.pymolScene.buildScene(name, thisScene, htObjNames, htSecrets);
                this.appendLoadNote("scene: " + name);
            }
        }
        this.pymolScene.setCarveSets(htObjNames);
    }

    private void finalizeSceneData() {
        int[] cartoonTypes = new int[this.ac];
        int[] uniqueIDs = new int[this.ac];
        int[] sequenceNumbers = new int[this.ac];
        boolean[] newChain = new boolean[this.ac];
        float[] radii = new float[this.ac];
        int lastAtomChain = Integer.MIN_VALUE;
        int lastAtomSet = Integer.MIN_VALUE;
        for (int i = 0; i < this.ac; ++i) {
            cartoonTypes[i] = this.getCartoonType(i);
            uniqueIDs[i] = this.getUniqueID(i);
            sequenceNumbers[i] = this.getSequenceNumber(i);
            radii[i] = this.getVDW(i);
            if (lastAtomChain == this.atoms[i].chainID && lastAtomSet == this.atoms[i].atomSetIndex) continue;
            newChain[i] = true;
            lastAtomChain = this.atoms[i].chainID;
            lastAtomSet = this.atoms[i].atomSetIndex;
        }
        this.pymolScene.setAtomInfo(uniqueIDs, cartoonTypes, sequenceNumbers, newChain, radii);
    }

    private static int intAt(Lst<Object> list, int i) {
        return list == null ? -1 : ((Number)list.get(i)).intValue();
    }

    private static String stringAt(Lst<Object> list, int i) {
        String s = list.get(i).toString();
        return s.length() == 0 ? " " : s;
    }

    private static Lst<Object> getMapList(Map<String, Object> map, String key) {
        return (Lst)map.get(key);
    }

    private static BS getBsReps(Lst<Object> list) {
        if (list == null) {
            return null;
        }
        BS bsReps = new BS();
        int n = Math.min(list.size(), 21);
        for (int i = 0; i < n; ++i) {
            if (PyMOLReader.intAt(list, i) != 1) continue;
            bsReps.set(i);
        }
        return bsReps;
    }

    private float floatAt(Lst<Object> a, int i) {
        return PyMOLScene.floatAt(a, i);
    }

    private Lst<Object> listAt(Lst<Object> list, int i) {
        return PyMOLScene.listAt(list, i);
    }

    @Override
    public int getUniqueID(int iAtom) {
        return (int)this.atoms[iAtom].vib.x;
    }

    @Override
    public int getCartoonType(int iAtom) {
        return (int)this.atoms[iAtom].vib.y;
    }

    @Override
    public float getVDW(int iAtom) {
        return this.atoms[iAtom].radius;
    }

    @Override
    public int getSequenceNumber(int iAtom) {
        return this.atoms[iAtom].sequenceNumber;
    }

    @Override
    public boolean compareAtoms(int iPrev, int i) {
        return this.atoms[iPrev].chainID != this.atoms[i].chainID;
    }
}

