/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language.arguments;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.BranchProfile;
import org.jruby.truffle.language.RubyGuards;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.arguments.RubyArguments;
import org.jruby.truffle.language.dispatch.RespondToNode;

public class ShouldDestructureNode
extends RubyNode {
    @Node.Child
    private RubyNode readArrayNode;
    @Node.Child
    private RespondToNode respondToCheck;
    private final BranchProfile checkIsArrayProfile = BranchProfile.create();

    public ShouldDestructureNode(RubyNode readArrayNode) {
        this.readArrayNode = readArrayNode;
    }

    @Override
    public boolean executeBoolean(VirtualFrame frame) {
        if (RubyArguments.getArgumentsCount(frame) != 1) {
            return false;
        }
        this.checkIsArrayProfile.enter();
        if (RubyGuards.isRubyArray(RubyArguments.getArgument(frame, 0))) {
            return true;
        }
        if (this.respondToCheck == null) {
            CompilerDirectives.transferToInterpreter();
            this.respondToCheck = this.insert(new RespondToNode(this.getContext(), this.getSourceSection(), this.readArrayNode, "to_ary"));
        }
        return this.respondToCheck.executeBoolean(frame);
    }

    @Override
    public Object execute(VirtualFrame frame) {
        return this.executeBoolean(frame);
    }
}

