# -*- coding: utf-8 -*-
# Auto-generated by BabelAPI, do not modify.
try:
    from . import babel_validators as bv
except (SystemError, ValueError):
    # Catch errors raised when importing a relative module when not in a package.
    # This makes testing this file directly (outside of a package) easier.
    import babel_validators as bv

class AuthError(object):
    """
    Errors occurred during authentication.

    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar invalid_access_token: The access token is invalid.
    :ivar invalid_select_user: The user specified in 'Dropbox-API-Select-User'
        is no longer on the team.
    :ivar other: An unspecified error.
    """

    __slots__ = ['_tag', '_value']

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    invalid_access_token = None
    # Attribute is overwritten below the class definition
    invalid_select_user = None
    # Attribute is overwritten below the class definition
    other = None

    def __init__(self, tag, value=None):
        assert tag in self._tagmap, 'Invalid tag %r.' % tag
        validator = self._tagmap[tag]
        if isinstance(validator, bv.Void):
            assert value is None, 'Void type union member must have None value.'
        elif isinstance(validator, (bv.Struct, bv.Union)):
            validator.validate_type_only(value)
        else:
            validator.validate(value)
        self._tag = tag
        self._value = value

    def is_invalid_access_token(self):
        """
        Check if the union tag is ``invalid_access_token``.

        :rtype: bool
        """
        return self._tag == 'invalid_access_token'

    def is_invalid_select_user(self):
        """
        Check if the union tag is ``invalid_select_user``.

        :rtype: bool
        """
        return self._tag == 'invalid_select_user'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def __repr__(self):
        return 'AuthError(%r, %r)' % (self._tag, self._value)

AuthError._invalid_access_token_validator = bv.Void()
AuthError._invalid_select_user_validator = bv.Void()
AuthError._other_validator = bv.Void()
AuthError._tagmap = {
    'invalid_access_token': AuthError._invalid_access_token_validator,
    'invalid_select_user': AuthError._invalid_select_user_validator,
    'other': AuthError._other_validator,
}

AuthError.invalid_access_token = AuthError('invalid_access_token')
AuthError.invalid_select_user = AuthError('invalid_select_user')
AuthError.other = AuthError('other')

