/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.element.facet.specific;

import com.baselet.control.basics.geom.PointDouble;
import com.baselet.control.enums.AlignHorizontal;
import com.baselet.diagram.draw.DrawHandler;
import com.baselet.diagram.draw.helper.ColorOwn;
import com.baselet.element.draw.DrawHelper;
import com.baselet.element.facet.Facet;
import com.baselet.element.facet.PropertiesParserState;
import com.baselet.gui.AutocompletionText;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class HierarchyFacet
extends Facet {
    private static final double ARROW_LENGTH = 12.0;
    private static final double CIRCLE_DIAMETER = 10.0;
    private static final String KEY = "type";
    public static final HierarchyFacet INSTANCE = new HierarchyFacet();

    @Override
    public boolean checkStart(String line, PropertiesParserState state) {
        return true;
    }

    @Override
    public void handleLine(String line, PropertiesParserState state) {
        if (line.isEmpty()) {
            return;
        }
        Cache cache = state.getOrInitFacetResponse(HierarchyFacet.class, new Cache());
        HierarchyType[] hierarchyTypeArray = HierarchyType.values();
        int n = hierarchyTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            HierarchyType type = hierarchyTypeArray[n2];
            if (line.equals("type=" + (Object)((Object)type))) {
                cache.type = type;
                return;
            }
            ++n2;
        }
        DrawHandler drawer = state.getDrawer();
        drawer.setLayer(DrawHandler.Layer.Foreground);
        ColorOwn bgBefore = drawer.getBackgroundColor();
        drawer.setBackgroundColor(ColorOwn.TRANSPARENT);
        String lineWithoutTabs = line.replace("\t", "");
        int tabCount = line.length() - lineWithoutTabs.length();
        int border = 10;
        PointDouble upperLeftPoint = null;
        PointDouble lowerRightPoint = null;
        PointDouble textPos = null;
        if (cache.type == HierarchyType.Actor) {
            int actorDimension = 10;
            int actorHCenter = border + actorDimension + actorDimension * 5 * tabCount;
            int actorVTop = border + cache.lineNr * actorDimension * 6;
            DrawHelper.drawActor(drawer, actorHCenter, actorVTop, actorDimension);
            upperLeftPoint = new PointDouble(actorHCenter, (double)actorVTop + (double)actorDimension * 5.5 + 12.0);
            lowerRightPoint = new PointDouble(actorHCenter - actorDimension * 2, (double)actorVTop + (double)actorDimension * 2.5);
            HierarchyFacet.drawLinesAndUpperLeftSymbol(lowerRightPoint, drawer, cache, lineWithoutTabs, tabCount, true);
            textPos = new PointDouble(actorHCenter + actorDimension * 2, actorVTop + actorDimension * 3);
            drawer.print(lineWithoutTabs, textPos, AlignHorizontal.LEFT);
            this.updateElementSize(state, lineWithoutTabs, lowerRightPoint, textPos, drawer.textWidth(lineWithoutTabs), DrawHelper.headToLegLength(actorDimension));
        } else if (cache.type == HierarchyType.Package) {
            int fullHeight = 20;
            int fullWidth = 30;
            double xPos = (double)border + (double)(tabCount * fullWidth) * 1.4;
            double yPos = (double)border + (double)(cache.lineNr * fullHeight) * 1.6;
            DrawHelper.drawPackage(drawer, xPos, yPos, 5.0, 10.0, fullHeight, fullWidth);
            upperLeftPoint = new PointDouble(xPos + (double)fullWidth * 0.3, yPos + (double)fullHeight + 10.0);
            lowerRightPoint = new PointDouble(xPos, yPos + (double)fullHeight * 0.5);
            HierarchyFacet.drawLinesAndUpperLeftSymbol(lowerRightPoint, drawer, cache, lineWithoutTabs, tabCount, false);
            textPos = new PointDouble(xPos + (double)fullWidth * 1.15, yPos + (double)fullHeight * 0.8);
            drawer.print(lineWithoutTabs, textPos, AlignHorizontal.LEFT);
            this.updateElementSize(state, lineWithoutTabs, lowerRightPoint, textPos, drawer.textWidth(lineWithoutTabs), fullHeight + 10);
        } else if (cache.type == HierarchyType.WorkProcess) {
            double fullHeight = 40.0;
            double fullWidth = 140.0;
            double xPos = (double)border + (double)tabCount * fullWidth;
            double yPos = (double)border + (double)cache.lineNr * fullHeight * 1.2;
            drawer.drawEllipse(xPos, yPos, fullWidth, fullHeight);
            upperLeftPoint = new PointDouble(xPos + fullWidth * 0.5, yPos + fullHeight + 12.0);
            lowerRightPoint = new PointDouble(xPos, yPos + fullHeight * 0.5);
            HierarchyFacet.drawLinesAndUpperLeftSymbol(lowerRightPoint, drawer, cache, lineWithoutTabs, tabCount, true);
            textPos = new PointDouble(xPos + fullWidth / 2.0, yPos + fullHeight / 2.0 + drawer.textHeight(lineWithoutTabs) / 2.0);
            drawer.print(lineWithoutTabs, textPos, AlignHorizontal.CENTER);
            this.updateElementSize(state, lineWithoutTabs, lowerRightPoint, textPos, fullWidth / 2.0, fullHeight);
        }
        if (tabCount == 0) {
            cache.points.clear();
        }
        while (cache.points.size() > tabCount) {
            cache.points.remove(cache.points.size() - 1);
        }
        cache.points.add(new ReferencePoint(upperLeftPoint));
        Cache cache2 = cache;
        cache2.lineNr = cache2.lineNr + 1;
        drawer.setLayer(DrawHandler.Layer.Background);
        drawer.setBackgroundColor(bgBefore);
    }

    private void updateElementSize(PropertiesParserState state, String lineWithoutTabs, PointDouble lowerRightPoint, PointDouble textPos, double widthAddon, double heightAddon) {
        state.updateMinimumSize(textPos.x + widthAddon, lowerRightPoint.y + heightAddon);
    }

    private static void drawLinesAndUpperLeftSymbol(PointDouble lowerRightPoint, DrawHandler drawer, Cache cache, String lineWithoutTabs, int tabCount, boolean arrow) {
        if (tabCount != 0) {
            try {
                ReferencePoint ref = (ReferencePoint)cache.points.get(tabCount - 1);
                PointDouble p1 = new PointDouble(lowerRightPoint.x, lowerRightPoint.y);
                PointDouble p2 = new PointDouble(ref.p.x, lowerRightPoint.y);
                PointDouble p3 = new PointDouble(ref.p.x, ref.p.y);
                drawer.drawLines(p1, p2, p3);
                if (!ref.hasSymbol) {
                    ref.hasSymbol = true;
                    if (arrow) {
                        PointDouble upper = new PointDouble(ref.p.x, ref.p.y - 12.0);
                        PointDouble lowerLeft = new PointDouble(ref.p.x - 6.0, ref.p.y);
                        PointDouble lowerRight = new PointDouble(ref.p.x + 6.0, ref.p.y);
                        drawer.drawLines(upper, lowerLeft, lowerRight, upper);
                    } else {
                        int dist = 2;
                        double circleRadius = 5.0;
                        drawer.drawCircle(ref.p.x, ref.p.y - circleRadius, circleRadius);
                        drawer.drawLine(ref.p.x, ref.p.y - 10.0 + (double)dist, ref.p.x, ref.p.y - (double)dist);
                        drawer.drawLine(ref.p.x - circleRadius + (double)dist, ref.p.y - circleRadius, ref.p.x + circleRadius - (double)dist, ref.p.y - circleRadius);
                    }
                }
            }
            catch (IndexOutOfBoundsException e) {
                throw new RuntimeException("Too many tabs in line nr." + (cache.lineNr + 1) + ": " + lineWithoutTabs);
            }
        }
    }

    @Override
    public List<AutocompletionText> getAutocompletionStrings() {
        return Arrays.asList(new AutocompletionText("type=" + (Object)((Object)HierarchyType.Actor), "draws hierarchy of actors"), new AutocompletionText("type=" + (Object)((Object)HierarchyType.Package), "draws hierarchy of packages"), new AutocompletionText("type=" + (Object)((Object)HierarchyType.WorkProcess), "draws hierarchy of work processes"));
    }

    private static final class Cache {
        HierarchyType type = HierarchyType.Actor;
        private int lineNr;
        private final List<ReferencePoint> points = new ArrayList<ReferencePoint>();

        private Cache() {
        }
    }

    public static enum HierarchyType {
        Actor,
        Package,
        WorkProcess;

    }

    private static final class ReferencePoint {
        PointDouble p;
        boolean hasSymbol = false;

        public ReferencePoint(PointDouble p) {
            this.p = p;
        }
    }
}

