/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.impl;

import com.sun.prism.Image;
import com.sun.prism.PixelFormat;
import com.sun.prism.Texture;
import com.sun.prism.impl.BaseGraphicsResource;
import com.sun.prism.impl.Disposer;
import java.nio.Buffer;

public abstract class BaseTexture
extends BaseGraphicsResource
implements Texture {
    private final PixelFormat format;
    private final int physicalWidth;
    private final int physicalHeight;
    private final int contentX;
    private final int contentY;
    private final int contentWidth;
    private final int contentHeight;
    private Texture.WrapMode wrapMode = Texture.WrapMode.CLAMP_TO_EDGE;
    private boolean linearFiltering = true;
    private int lastImageSerial;

    protected BaseTexture(PixelFormat pixelFormat, int n, int n2, int n3, int n4, int n5, int n6, Disposer.Record record) {
        super(record);
        this.format = pixelFormat;
        this.physicalWidth = n;
        this.physicalHeight = n2;
        this.contentX = n3;
        this.contentY = n4;
        this.contentWidth = n5;
        this.contentHeight = n6;
    }

    @Override
    public PixelFormat getPixelFormat() {
        return this.format;
    }

    @Override
    public int getPhysicalWidth() {
        return this.physicalWidth;
    }

    @Override
    public int getPhysicalHeight() {
        return this.physicalHeight;
    }

    @Override
    public int getContentX() {
        return this.contentX;
    }

    @Override
    public int getContentY() {
        return this.contentY;
    }

    @Override
    public int getContentWidth() {
        return this.contentWidth;
    }

    @Override
    public int getContentHeight() {
        return this.contentHeight;
    }

    @Override
    public Texture.WrapMode getWrapMode() {
        return this.wrapMode;
    }

    @Override
    public void setWrapMode(Texture.WrapMode wrapMode) {
        this.wrapMode = wrapMode;
    }

    @Override
    public boolean getLinearFiltering() {
        return this.linearFiltering;
    }

    @Override
    public void setLinearFiltering(boolean bl) {
        this.linearFiltering = bl;
    }

    @Override
    public int getLastImageSerial() {
        return this.lastImageSerial;
    }

    @Override
    public void setLastImageSerial(int n) {
        this.lastImageSerial = n;
    }

    @Override
    public void update(Image image) {
        this.update(image, 0, 0);
    }

    @Override
    public void update(Image image, int n, int n2) {
        this.update(image, n, n2, image.getWidth(), image.getHeight());
    }

    @Override
    public void update(Image image, int n, int n2, int n3, int n4) {
        this.update(image, n, n2, n3, n4, false);
    }

    @Override
    public void update(Image image, int n, int n2, int n3, int n4, boolean bl) {
        Buffer buffer = image.getPixelBuffer();
        int n5 = buffer.position();
        this.update(buffer, image.getPixelFormat(), n, n2, image.getMinX(), image.getMinY(), n3, n4, image.getScanlineStride(), bl);
        buffer.position(n5);
    }

    protected void checkUpdateParams(Buffer buffer, PixelFormat pixelFormat, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        if (this.format == PixelFormat.MULTI_YCbCr_420) {
            throw new IllegalArgumentException("MULTI_YCbCr_420 requires multitexturing");
        }
        if (buffer == null) {
            throw new IllegalArgumentException("Pixel buffer must be non-null");
        }
        if (pixelFormat != this.format) {
            throw new IllegalArgumentException("Image format (" + (Object)((Object)pixelFormat) + ") " + "must match texture format (" + (Object)((Object)this.format) + ")");
        }
        if (n < 0 || n2 < 0) {
            throw new IllegalArgumentException("dstx (" + n + ") and dsty (" + n2 + ") must be >= 0");
        }
        if (n3 < 0 || n4 < 0) {
            throw new IllegalArgumentException("srcx (" + n3 + ") and srcy (" + n4 + ") must be >= 0");
        }
        if (n5 <= 0 || n6 <= 0) {
            throw new IllegalArgumentException("srcw (" + n5 + ") and srch (" + n6 + ") must be > 0");
        }
        int n8 = pixelFormat.getBytesPerPixelUnit();
        if (n7 % n8 != 0) {
            throw new IllegalArgumentException("srcscan (" + n7 + ") " + "must be a multiple of the pixel stride (" + n8 + ")");
        }
        if (n5 > n7 / n8) {
            throw new IllegalArgumentException("srcw (" + n5 + ") " + "must be <= srcscan/bytesPerPixel (" + n7 / n8 + ")");
        }
        if (n + n5 > this.contentWidth || n2 + n6 > this.contentHeight) {
            throw new IllegalArgumentException("Destination region (x=" + n + ", y=" + n2 + ", w=" + n5 + ", h=" + n6 + ") " + "must fit within texture content bounds " + "(contentWidth=" + this.contentWidth + ", contentHeight=" + this.contentHeight + ")");
        }
        int n9 = n3 * n8 + n4 * n7 + (n6 - 1) * n7 + n5 * n8;
        int n10 = n9 / this.format.getDataType().getSizeInBytes();
        if (n10 > buffer.remaining()) {
            throw new IllegalArgumentException("Upload requires " + n10 + " elements, but only " + buffer.remaining() + " elements remain in the buffer");
        }
    }

    public String toString() {
        return super.toString() + " [format=" + (Object)((Object)this.format) + " physicalWidth=" + this.physicalWidth + " physicalHeight=" + this.physicalHeight + " contentX=" + this.contentX + " contentY=" + this.contentY + " contentWidth=" + this.contentWidth + " contentHeight=" + this.contentHeight + " wrapMode=" + (Object)((Object)this.wrapMode) + " linearFiltering=" + this.linearFiltering + "]";
    }
}

