/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.api;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.zaproxy.zap.extension.api.API;
import org.zaproxy.zap.extension.api.ApiElement;
import org.zaproxy.zap.extension.api.ApiGeneratorUtils;
import org.zaproxy.zap.extension.api.ApiImplementor;

public class PhpAPIGenerator {
    private File dir;
    private boolean optional = false;
    private final String HEADER = "<?php\n/**\n * Zed Attack Proxy (ZAP) and its related class files.\n *\n * ZAP is an HTTP/HTTPS proxy for assessing web application security.\n *\n * Copyright 2016 the ZAP development team\n *\n * Licensed under the Apache License, Version 2.0 (the \"License\");\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n *   http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an \"AS IS\" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n */\n\n\n";
    private final String OPTIONAL_MASSAGE = "This component is optional and therefore the API will only work if it is installed";
    private ResourceBundle msgs = ResourceBundle.getBundle("lang.Messages", Locale.ENGLISH, ResourceBundle.Control.getControl(ResourceBundle.Control.FORMAT_PROPERTIES));
    private static final Map<String, String> nameMap;

    public PhpAPIGenerator() {
        this.dir = new File("php/api/zapv2/src/Zap");
    }

    public PhpAPIGenerator(String string, boolean bl) {
        this.dir = new File(string);
        this.optional = bl;
    }

    public void generatePhpFiles(List<ApiImplementor> list) throws IOException {
        for (ApiImplementor apiImplementor : list) {
            this.generatePhpComponent(apiImplementor);
        }
    }

    private void generatePhpElement(ApiElement apiElement, String string, String string2, Writer writer) throws IOException {
        String string3;
        boolean bl;
        block30: {
            bl = apiElement.getMandatoryParamNames() != null && apiElement.getMandatoryParamNames().size() > 0 || apiElement.getOptionalParamNames() != null && apiElement.getOptionalParamNames().size() > 0;
            String string4 = apiElement.getDescriptionTag();
            if (string4 == null) {
                string4 = string + ".api." + string2 + "." + apiElement.getName();
            }
            try {
                string3 = this.msgs.getString(string4);
                writer.write("\t/**\n");
                writer.write("\t * " + string3 + "\n");
                if (this.optional) {
                    writer.write("\t * This component is optional and therefore the API will only work if it is installed\n");
                }
                writer.write("\t */\n");
            }
            catch (Exception exception) {
                System.out.println("No i18n for: " + string4);
                if (!this.optional) break block30;
                writer.write("\t/**\n");
                writer.write("\t * This component is optional and therefore the API will only work if it is installed\n");
                writer.write("\t */\n");
            }
        }
        writer.write("\tpublic function " + PhpAPIGenerator.createMethodName(apiElement.getName()) + "(");
        string3 = "";
        if (apiElement.getMandatoryParamNames() != null) {
            for (String object2 : apiElement.getMandatoryParamNames()) {
                if (string3 != "") {
                    string3 = string3 + ", ";
                }
                string3 = string3 + "$" + object2.toLowerCase();
            }
            writer.write(string3);
        }
        Object object3 = "";
        if (apiElement.getOptionalParamNames() != null) {
            for (String string4 : apiElement.getOptionalParamNames()) {
                if (string3 != "" || object3 != "") {
                    object3 = (String)object3 + ", ";
                }
                object3 = (String)object3 + "$" + string4.toLowerCase() + "=NULL";
            }
            writer.write((String)object3);
        }
        if (string2.equals("action") || string2.equals("other")) {
            if (bl) {
                writer.write(", ");
            }
            writer.write("$" + API.API_KEY_PARAM + "=''");
            bl = true;
        }
        writer.write(") {\n");
        StringBuilder stringBuilder = new StringBuilder();
        if (bl) {
            stringBuilder.append("array(");
            boolean bl2 = true;
            if (apiElement.getMandatoryParamNames() != null) {
                for (String string5 : apiElement.getMandatoryParamNames()) {
                    if (bl2) {
                        bl2 = false;
                    } else {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append("'" + string5 + "' => $" + string5.toLowerCase());
                }
            }
            if (string2.equals("action") || string2.equals("other")) {
                if (!bl2) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append("'").append(API.API_KEY_PARAM).append("' => $").append(API.API_KEY_PARAM);
            }
            stringBuilder.append(")");
            if (apiElement.getOptionalParamNames() != null && !apiElement.getOptionalParamNames().isEmpty()) {
                writer.write("\t\t$params = ");
                writer.write(stringBuilder.toString());
                writer.write(";\n");
                stringBuilder.replace(0, stringBuilder.length(), "$params");
                for (String string5 : apiElement.getOptionalParamNames()) {
                    writer.write("\t\tif ($" + string5.toLowerCase() + " !== NULL) {\n");
                    writer.write("\t\t\t$params['" + string5 + "'] = $" + string5.toLowerCase() + ";\n");
                    writer.write("\t\t}\n");
                }
            }
        }
        String string6 = "request";
        Iterator<String> iterator = "base";
        if (string2.equals("other")) {
            string6 = string6 + "other";
            iterator = (String)((Object)iterator) + "_other";
        }
        writer.write("\t\treturn $this->zap->" + string6 + "($this->zap->" + (String)((Object)iterator) + " . '" + string + "/" + string2 + "/" + apiElement.getName() + "/'");
        if (bl) {
            writer.write(", ");
            writer.write(stringBuilder.toString());
            writer.write(")");
            if (string2.equals("view")) {
                writer.write("->{'" + apiElement.getName() + "'};\n");
            } else {
                writer.write(";\n");
            }
        } else if (!string2.equals("other")) {
            if (apiElement.getName().startsWith("option")) {
                writer.write(")->{'" + apiElement.getName().substring(6) + "'};\n");
            } else {
                writer.write(")->{'" + apiElement.getName() + "'};\n");
            }
        } else {
            writer.write(");\n");
        }
        writer.write("\t}\n\n");
    }

    private static String createMethodName(String string) {
        if (nameMap.containsKey(string)) {
            string = nameMap.get(string);
        }
        return PhpAPIGenerator.removeAllFullStopCharacters(string);
    }

    private static String removeAllFullStopCharacters(String string) {
        return string.replaceAll("\\.", "");
    }

    private void generatePhpComponent(ApiImplementor apiImplementor) throws IOException {
        String string = PhpAPIGenerator.safeName(apiImplementor.getPrefix().substring(0, 1).toUpperCase() + apiImplementor.getPrefix().substring(1));
        File file = new File(this.dir, string + ".php");
        System.out.println("Generating " + file.getAbsolutePath());
        FileWriter fileWriter = new FileWriter(file);
        fileWriter.write("<?php\n/**\n * Zed Attack Proxy (ZAP) and its related class files.\n *\n * ZAP is an HTTP/HTTPS proxy for assessing web application security.\n *\n * Copyright 2016 the ZAP development team\n *\n * Licensed under the Apache License, Version 2.0 (the \"License\");\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n *   http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an \"AS IS\" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n */\n\n\n");
        fileWriter.write("namespace Zap;\n\n");
        fileWriter.write("\n");
        fileWriter.write("/**\n");
        fileWriter.write(" * This file was automatically generated.\n");
        fileWriter.write(" */\n");
        fileWriter.write("class " + string + " {\n\n");
        fileWriter.write("\tpublic function __construct ($zap) {\n");
        fileWriter.write("\t\t$this->zap = $zap;\n");
        fileWriter.write("\t}\n\n");
        for (ApiElement apiElement : apiImplementor.getApiViews()) {
            this.generatePhpElement(apiElement, apiImplementor.getPrefix(), "view", fileWriter);
        }
        for (ApiElement apiElement : apiImplementor.getApiActions()) {
            this.generatePhpElement(apiElement, apiImplementor.getPrefix(), "action", fileWriter);
        }
        for (ApiElement apiElement : apiImplementor.getApiOthers()) {
            this.generatePhpElement(apiElement, apiImplementor.getPrefix(), "other", fileWriter);
        }
        fileWriter.write("}\n");
        fileWriter.close();
    }

    private static String safeName(String string) {
        if (nameMap.containsKey(string)) {
            return nameMap.get(string);
        }
        return string;
    }

    public static void main(String[] stringArray) throws Exception {
        PhpAPIGenerator phpAPIGenerator = new PhpAPIGenerator();
        phpAPIGenerator.generatePhpFiles(ApiGeneratorUtils.getAllImplementors());
    }

    static {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("Break", "Brk");
        hashMap.put("break", "brk");
        nameMap = Collections.unmodifiableMap(hashMap);
    }
}

