/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow.table;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.apache.fop.fo.ValidationException;
import org.apache.fop.fo.flow.table.BorderResolver;
import org.apache.fop.fo.flow.table.CollapsingBorderResolver;
import org.apache.fop.fo.flow.table.EmptyGridUnit;
import org.apache.fop.fo.flow.table.GridUnit;
import org.apache.fop.fo.flow.table.PrimaryGridUnit;
import org.apache.fop.fo.flow.table.RowGroupBuilder;
import org.apache.fop.fo.flow.table.SeparateBorderResolver;
import org.apache.fop.fo.flow.table.Table;
import org.apache.fop.fo.flow.table.TableCell;
import org.apache.fop.fo.flow.table.TableCellContainer;
import org.apache.fop.fo.flow.table.TableEventProducer;
import org.apache.fop.fo.flow.table.TablePart;
import org.apache.fop.fo.flow.table.TableRow;

class FixedColRowGroupBuilder
extends RowGroupBuilder {
    private int numberOfColumns;
    private TableRow currentTableRow;
    private int currentRowIndex;
    private List rows;
    private boolean firstInPart = true;
    private List lastRow;
    private BorderResolver borderResolver;

    FixedColRowGroupBuilder(Table t) {
        super(t);
        this.numberOfColumns = t.getNumberOfColumns();
        this.borderResolver = t.isSeparateBorderModel() ? new SeparateBorderResolver() : new CollapsingBorderResolver(t);
        this.initialize();
    }

    private void initialize() {
        this.rows = new ArrayList();
        this.currentRowIndex = 0;
    }

    void addTableCell(TableCell cell) {
        for (int i = this.rows.size(); i < this.currentRowIndex + cell.getNumberRowsSpanned(); ++i) {
            ArrayList<Object> effRow = new ArrayList<Object>(this.numberOfColumns);
            for (int j = 0; j < this.numberOfColumns; ++j) {
                effRow.add(null);
            }
            this.rows.add(effRow);
        }
        int columnIndex = cell.getColumnNumber() - 1;
        PrimaryGridUnit pgu = new PrimaryGridUnit(cell, columnIndex);
        List row = (List)this.rows.get(this.currentRowIndex);
        row.set(columnIndex, pgu);
        GridUnit[] cellRow = new GridUnit[cell.getNumberColumnsSpanned()];
        cellRow[0] = pgu;
        for (int j = 1; j < cell.getNumberColumnsSpanned(); ++j) {
            GridUnit gu = new GridUnit(pgu, j, 0);
            row.set(columnIndex + j, gu);
            cellRow[j] = gu;
        }
        pgu.addRow(cellRow);
        for (int i = 1; i < cell.getNumberRowsSpanned(); ++i) {
            row = (List)this.rows.get(this.currentRowIndex + i);
            cellRow = new GridUnit[cell.getNumberColumnsSpanned()];
            for (int j = 0; j < cell.getNumberColumnsSpanned(); ++j) {
                GridUnit gu = new GridUnit(pgu, j, i);
                row.set(columnIndex + j, gu);
                cellRow[j] = gu;
            }
            pgu.addRow(cellRow);
        }
    }

    private static void setFlagForCols(int flag, List row) {
        ListIterator iter = row.listIterator();
        while (iter.hasNext()) {
            ((GridUnit)iter.next()).setFlag(flag);
        }
    }

    void startTableRow(TableRow tableRow) {
        this.currentTableRow = tableRow;
    }

    void endTableRow() {
        TableEventProducer eventProducer;
        assert (this.currentTableRow != null);
        if (this.currentRowIndex > 0 && this.currentTableRow.getBreakBefore() != 9) {
            eventProducer = TableEventProducer.Provider.get(this.currentTableRow.getUserAgent().getEventBroadcaster());
            eventProducer.breakIgnoredDueToRowSpanning(this, this.currentTableRow.getName(), true, this.currentTableRow.getLocator());
        }
        if (this.currentRowIndex < this.rows.size() - 1 && this.currentTableRow.getBreakAfter() != 9) {
            eventProducer = TableEventProducer.Provider.get(this.currentTableRow.getUserAgent().getEventBroadcaster());
            eventProducer.breakIgnoredDueToRowSpanning(this, this.currentTableRow.getName(), false, this.currentTableRow.getLocator());
        }
        for (GridUnit gu : (List)this.rows.get(this.currentRowIndex)) {
            if (gu == null) continue;
            gu.setRow(this.currentTableRow);
        }
        this.handleRowEnd(this.currentTableRow);
    }

    void endRow(TablePart part) {
        this.handleRowEnd(part);
    }

    private void handleRowEnd(TableCellContainer container) {
        List currentRow;
        this.lastRow = currentRow = (List)this.rows.get(this.currentRowIndex);
        for (int i = 0; i < this.numberOfColumns; ++i) {
            if (currentRow.get(i) != null) continue;
            currentRow.set(i, new EmptyGridUnit(this.table, this.currentTableRow, i));
        }
        this.borderResolver.endRow(currentRow, container);
        if (this.firstInPart) {
            FixedColRowGroupBuilder.setFlagForCols(0, currentRow);
            this.firstInPart = false;
        }
        if (this.currentRowIndex == this.rows.size() - 1) {
            container.getTablePart().addRowGroup(this.rows);
            this.initialize();
        } else {
            ++this.currentRowIndex;
        }
        this.currentTableRow = null;
    }

    void startTablePart(TablePart part) {
        this.firstInPart = true;
        this.borderResolver.startPart(part);
    }

    void endTablePart() throws ValidationException {
        if (this.rows.size() > 0) {
            throw new ValidationException("A table-cell is spanning more rows than available in its parent element.");
        }
        FixedColRowGroupBuilder.setFlagForCols(1, this.lastRow);
        this.borderResolver.endPart();
    }

    void endTable() {
        this.borderResolver.endTable();
    }
}

