/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang.ObjectUtils;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.ResolvedDependency;
import org.gradle.api.artifacts.ResolvedModuleVersion;
import org.gradle.api.internal.artifacts.ResolvedConfigurationIdentifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultResolvedDependency
implements ResolvedDependency {
    private final Set<ResolvedDependency> children = new LinkedHashSet<ResolvedDependency>();
    private final Set<ResolvedDependency> parents = new LinkedHashSet<ResolvedDependency>();
    private final Map<ResolvedDependency, Set<ResolvedArtifact>> parentArtifacts = new LinkedHashMap<ResolvedDependency, Set<ResolvedArtifact>>();
    private final String name;
    private final ResolvedConfigurationIdentifier id;
    private final Set<ResolvedArtifact> moduleArtifacts;
    private final Map<ResolvedDependency, Set<ResolvedArtifact>> allArtifactsCache = new HashMap<ResolvedDependency, Set<ResolvedArtifact>>();
    private Set<ResolvedArtifact> allModuleArtifactsCache;

    public DefaultResolvedDependency(ModuleVersionIdentifier moduleVersionIdentifier, String configuration) {
        this.name = String.format("%s:%s:%s", moduleVersionIdentifier.getGroup(), moduleVersionIdentifier.getName(), moduleVersionIdentifier.getVersion());
        this.id = new ResolvedConfigurationIdentifier(moduleVersionIdentifier, configuration);
        this.moduleArtifacts = new TreeSet<ResolvedArtifact>(new ResolvedArtifactComparator());
    }

    public String getName() {
        return this.name;
    }

    public ResolvedConfigurationIdentifier getId() {
        return this.id;
    }

    public String getModuleGroup() {
        return this.id.getModuleGroup();
    }

    public String getModuleName() {
        return this.id.getModuleName();
    }

    public String getModuleVersion() {
        return this.id.getModuleVersion();
    }

    public String getConfiguration() {
        return this.id.getConfiguration();
    }

    public ResolvedModuleVersion getModule() {
        return new ResolvedModuleVersion(){

            public ModuleVersionIdentifier getId() {
                return DefaultResolvedDependency.this.id.getId();
            }
        };
    }

    public Set<ResolvedDependency> getChildren() {
        return this.children;
    }

    public Set<ResolvedArtifact> getModuleArtifacts() {
        return this.moduleArtifacts;
    }

    public Set<ResolvedArtifact> getAllModuleArtifacts() {
        if (this.allModuleArtifactsCache == null) {
            LinkedHashSet<ResolvedArtifact> allArtifacts = new LinkedHashSet<ResolvedArtifact>();
            allArtifacts.addAll(this.getModuleArtifacts());
            for (ResolvedDependency childResolvedDependency : this.getChildren()) {
                allArtifacts.addAll(childResolvedDependency.getAllModuleArtifacts());
            }
            this.allModuleArtifactsCache = allArtifacts;
        }
        return this.allModuleArtifactsCache;
    }

    public Set<ResolvedArtifact> getParentArtifacts(ResolvedDependency parent) {
        if (!this.parents.contains(parent)) {
            throw new InvalidUserDataException("Provided dependency (" + parent + ") must be a parent of: " + this);
        }
        Set<ResolvedArtifact> artifacts = this.parentArtifacts.get(parent);
        return artifacts == null ? Collections.emptySet() : artifacts;
    }

    public Set<ResolvedArtifact> getArtifacts(ResolvedDependency parent) {
        return this.getParentArtifacts(parent);
    }

    public Set<ResolvedArtifact> getAllArtifacts(ResolvedDependency parent) {
        if (this.allArtifactsCache.get(parent) == null) {
            LinkedHashSet<ResolvedArtifact> allArtifacts = new LinkedHashSet<ResolvedArtifact>();
            allArtifacts.addAll(this.getArtifacts(parent));
            for (ResolvedDependency childResolvedDependency : this.getChildren()) {
                for (ResolvedDependency childParent : childResolvedDependency.getParents()) {
                    allArtifacts.addAll(childResolvedDependency.getAllArtifacts(childParent));
                }
            }
            this.allArtifactsCache.put(parent, allArtifacts);
        }
        return this.allArtifactsCache.get(parent);
    }

    public Set<ResolvedDependency> getParents() {
        return this.parents;
    }

    public String toString() {
        return this.name + ";" + this.getConfiguration();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultResolvedDependency that = (DefaultResolvedDependency)o;
        return this.id.equals(that.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public void addChild(DefaultResolvedDependency child) {
        this.children.add(child);
        child.parents.add(this);
    }

    public void addParentSpecificArtifacts(ResolvedDependency parent, Set<ResolvedArtifact> artifacts) {
        Set<ResolvedArtifact> parentArtifacts = this.parentArtifacts.get(parent);
        if (parentArtifacts == null) {
            parentArtifacts = new TreeSet<ResolvedArtifact>(new ResolvedArtifactComparator());
            this.parentArtifacts.put(parent, parentArtifacts);
        }
        parentArtifacts.addAll(artifacts);
        this.moduleArtifacts.addAll(artifacts);
    }

    public void addModuleArtifact(ResolvedArtifact artifact) {
        this.moduleArtifacts.add(artifact);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ResolvedArtifactComparator
    implements Comparator<ResolvedArtifact> {
        private ResolvedArtifactComparator() {
        }

        @Override
        public int compare(ResolvedArtifact artifact1, ResolvedArtifact artifact2) {
            int diff = artifact1.getName().compareTo(artifact2.getName());
            if (diff != 0) {
                return diff;
            }
            diff = ObjectUtils.compare((Comparable)((Object)artifact1.getClassifier()), (Comparable)((Object)artifact2.getClassifier()));
            if (diff != 0) {
                return diff;
            }
            diff = artifact1.getExtension().compareTo(artifact2.getExtension());
            if (diff != 0) {
                return diff;
            }
            diff = artifact1.getType().compareTo(artifact2.getType());
            if (diff != 0) {
                return diff;
            }
            return artifact1.hashCode() - artifact2.hashCode();
        }
    }
}

