/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.text;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class LineReader {
    private int myPos = -1;
    private final int[] myBuffer = new int[2];
    private final InputStream myInputStream;
    private boolean myAtEnd = false;

    public LineReader(InputStream in) {
        this.myInputStream = in;
    }

    public List<byte[]> readLines() throws IOException {
        byte[] line;
        ArrayList<byte[]> result = new ArrayList<byte[]>();
        while ((line = this.readLineInternal()) != null) {
            result.add(line);
        }
        return result;
    }

    public byte[] readLine() throws IOException {
        return this.readLineInternal();
    }

    private int read() throws IOException {
        if (this.myPos >= 0) {
            int result = this.myBuffer[this.myPos];
            --this.myPos;
            return result;
        }
        return this.myInputStream.read();
    }

    @Nullable
    private byte[] readLineInternal() throws IOException {
        return new ReadLine().execute();
    }

    private void unread(int b) throws IOException {
        ++this.myPos;
        if (this.myPos >= this.myBuffer.length) {
            throw new IOException("Push back buffer is full");
        }
        this.myBuffer[this.myPos] = b;
    }

    private class ReadLine {
        private String myCurrentEOL = "";
        private ByteArrayOutputStream myResult = null;

        private ReadLine() {
        }

        @Nullable
        public byte[] execute() throws IOException {
            if (LineReader.this.myAtEnd) {
                return null;
            }
            InputStream inputStream = LineReader.this.myInputStream;
            synchronized (inputStream) {
                while (true) {
                    int ch;
                    if ((ch = LineReader.this.read()) < 0) {
                        return this.processEndOfStream();
                    }
                    if (this.notLineSeparator(ch)) {
                        if (this.myCurrentEOL.equals("\r")) {
                            LineReader.this.unread(ch);
                            return this.getResult();
                        }
                        if (this.myCurrentEOL.equals("\r\r")) {
                            LineReader.this.unread(ch);
                            LineReader.this.unread(13);
                            return this.getResult();
                        }
                        this.appendToResult(ch);
                        continue;
                    }
                    if (ch == 13) {
                        if (this.myCurrentEOL.isEmpty() || this.myCurrentEOL.equals("\r")) {
                            this.myCurrentEOL = this.myCurrentEOL + "\r";
                            continue;
                        }
                        if (!this.myCurrentEOL.equals("\r\r")) continue;
                        LineReader.this.unread(13);
                        LineReader.this.unread(13);
                        return this.getResult();
                    }
                    if (ch == 10) break;
                }
                return this.getResult();
            }
        }

        private boolean notLineSeparator(int ch) {
            return ch != 13 && ch != 10;
        }

        private void appendToResult(int ch) {
            this.createResult();
            this.myResult.write(ch);
        }

        private byte[] getResult() {
            this.createResult();
            try {
                this.myResult.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return this.myResult.toByteArray();
        }

        private void createResult() {
            if (this.myResult == null) {
                this.myResult = new ByteArrayOutputStream();
            }
        }

        private byte[] processEndOfStream() {
            LineReader.this.myAtEnd = true;
            return this.getResult();
        }
    }
}

