/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.border.CustomLineBorder;
import com.intellij.util.SystemProperties;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBFont;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.plaf.UIResource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JBUI {
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.ui.JBUI");
    private static float scaleFactor = 1.0f;

    private static void calculateScaleFactor() {
        if (SystemInfo.isMac) {
            LOG.info("UI scale factor: 1.0");
            scaleFactor = 1.0f;
            return;
        }
        if (SystemProperties.has("hidpi") && !SystemProperties.is("hidpi")) {
            LOG.info("UI scale factor: 1.0");
            scaleFactor = 1.0f;
            return;
        }
        UIUtil.initSystemFontData();
        Pair<String, Integer> fdata = UIUtil.getSystemFontData();
        int size = fdata != null ? fdata.getSecond().intValue() : Fonts.label().getSize();
        JBUI.setScaleFactor((float)size / 12.0f);
    }

    public static void setScaleFactor(float scale) {
        if (SystemProperties.has("hidpi") && !SystemProperties.is("hidpi")) {
            return;
        }
        scale = scale < 1.25f ? 1.0f : (scale < 1.5f ? 1.25f : (scale < 1.75f ? 1.5f : (scale < 2.0f ? 1.75f : 2.0f)));
        if (SystemInfo.isLinux && scale == 1.25f) {
            scale = 1.0f;
        }
        if (scaleFactor == scale) {
            return;
        }
        LOG.info("UI scale factor: " + scale);
        scaleFactor = scale;
        IconLoader.setScale(scale);
    }

    public static int scale(int i) {
        return Math.round(scaleFactor * (float)i);
    }

    public static int scaleFontSize(int fontSize) {
        if (scaleFactor == 1.25f) {
            return (int)((float)fontSize * 1.34f);
        }
        if (scaleFactor == 1.75f) {
            return (int)((float)fontSize * 1.67f);
        }
        return JBUI.scale(fontSize);
    }

    public static JBDimension size(int width, int height) {
        return new JBDimension(width, height);
    }

    public static JBDimension size(int widthAndHeight) {
        return new JBDimension(widthAndHeight, widthAndHeight);
    }

    public static JBDimension size(Dimension size) {
        if (size instanceof JBDimension) {
            JBDimension jbSize = (JBDimension)size;
            if (jbSize.originalScale == JBUI.scale(1.0f)) {
                return jbSize;
            }
            JBDimension newSize = new JBDimension((int)((float)jbSize.width / jbSize.originalScale), (int)((float)jbSize.height / jbSize.originalScale));
            return size instanceof UIResource ? newSize.asUIResource() : newSize;
        }
        return new JBDimension(size.width, size.height);
    }

    public static JBInsets insets(int top, int left, int bottom, int right) {
        return new JBInsets(top, left, bottom, right);
    }

    public static JBInsets insets(int all) {
        return JBUI.insets(all, all, all, all);
    }

    public static JBInsets insets(int topBottom, int leftRight) {
        return JBUI.insets(topBottom, leftRight, topBottom, leftRight);
    }

    public static JBInsets emptyInsets() {
        return new JBInsets(0, 0, 0, 0);
    }

    public static JBInsets insetsTop(int t) {
        return JBUI.insets(t, 0, 0, 0);
    }

    public static JBInsets insetsLeft(int l) {
        return JBUI.insets(0, l, 0, 0);
    }

    public static JBInsets insetsBottom(int b) {
        return JBUI.insets(0, 0, b, 0);
    }

    public static JBInsets insetsRight(int r) {
        return JBUI.insets(0, 0, 0, r);
    }

    public static EmptyIcon emptyIcon(int i) {
        return (EmptyIcon)EmptyIcon.create(JBUI.scale(i));
    }

    public static JBDimension emptySize() {
        return new JBDimension(0, 0);
    }

    public static float scale(float f) {
        return f * scaleFactor;
    }

    public static JBInsets insets(Insets insets) {
        return JBInsets.create(insets);
    }

    public static boolean isHiDPI() {
        return scaleFactor > 1.0f;
    }

    static {
        JBUI.calculateScaleFactor();
    }

    public static class Panels {
        public static BorderLayoutPanel simplePanel() {
            return new BorderLayoutPanel();
        }

        public static BorderLayoutPanel simplePanel(Component comp) {
            return Panels.simplePanel().addToCenter(comp);
        }

        public static BorderLayoutPanel simplePanel(int hgap, int vgap) {
            return new BorderLayoutPanel(hgap, vgap);
        }
    }

    public static class Borders {
        public static JBEmptyBorder empty(int top, int left, int bottom, int right) {
            return new JBEmptyBorder(top, left, bottom, right);
        }

        public static JBEmptyBorder empty(int topAndBottom, int leftAndRight) {
            return Borders.empty(topAndBottom, leftAndRight, topAndBottom, leftAndRight);
        }

        public static JBEmptyBorder emptyTop(int offset) {
            return Borders.empty(offset, 0, 0, 0);
        }

        public static JBEmptyBorder emptyLeft(int offset) {
            return Borders.empty(0, offset, 0, 0);
        }

        public static JBEmptyBorder emptyBottom(int offset) {
            return Borders.empty(0, 0, offset, 0);
        }

        public static JBEmptyBorder emptyRight(int offset) {
            return Borders.empty(0, 0, 0, offset);
        }

        public static JBEmptyBorder empty() {
            return Borders.empty(0, 0, 0, 0);
        }

        public static Border empty(int offsets) {
            return Borders.empty(offsets, offsets, offsets, offsets);
        }

        public static Border customLine(Color color, int top, int left, int bottom, int right) {
            return new CustomLineBorder(color, JBUI.insets(top, left, bottom, right));
        }

        public static Border customLine(Color color, int thickness) {
            return Borders.customLine(color, thickness, thickness, thickness, thickness);
        }

        public static Border customLine(Color color) {
            return Borders.customLine(color, 1);
        }

        public static Border merge(@Nullable Border source, @NotNull Border extra, boolean extraIsOutside) {
            if (extra == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extra", "com/intellij/util/ui/JBUI$Borders", "merge"));
            }
            if (source == null) {
                return extra;
            }
            return new CompoundBorder(extraIsOutside ? extra : source, extraIsOutside ? source : extra);
        }
    }

    public static class Fonts {
        public static JBFont label() {
            return JBFont.create(UIManager.getFont("Label.font"), false);
        }

        public static JBFont label(float size) {
            return Fonts.label().deriveFont(JBUI.scale(size));
        }

        public static JBFont smallFont() {
            return Fonts.label().deriveFont(UIUtil.getFontSize(UIUtil.FontSize.SMALL));
        }

        public static JBFont miniFont() {
            return Fonts.label().deriveFont(UIUtil.getFontSize(UIUtil.FontSize.MINI));
        }

        public static JBFont create(String fontFamily, int size) {
            return JBFont.create(new Font(fontFamily, 0, size));
        }
    }
}

