/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xmlb;

import com.intellij.util.xmlb.AbstractCollectionBinding;
import com.intellij.util.xmlb.MutableAccessor;
import com.intellij.util.xmlb.XmlSerializerImpl;
import java.lang.reflect.ParameterizedType;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CollectionBinding
extends AbstractCollectionBinding {
    public CollectionBinding(@NotNull ParameterizedType type, @Nullable MutableAccessor accessor) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/util/xmlb/CollectionBinding", "<init>"));
        }
        super(XmlSerializerImpl.typeToClass(type.getActualTypeArguments()[0]), accessor);
    }

    @Override
    Object processResult(Collection result, Object target) {
        if (this.myAccessor == null) {
            return result;
        }
        assert (target != null) : "Null target in " + this.myAccessor;
        assert (target instanceof Collection) : "Wrong target: " + target.getClass() + " in " + this.myAccessor;
        Collection c = (Collection)target;
        c.clear();
        c.addAll(result);
        return target;
    }

    @Override
    @NotNull
    Collection<Object> getIterable(@NotNull Object o) {
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/util/xmlb/CollectionBinding", "getIterable"));
        }
        Collection collection = o instanceof Set ? new TreeSet((Set)o) : (Collection)o;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xmlb/CollectionBinding", "getIterable"));
        }
        return collection;
    }

    @Override
    protected String getCollectionTagName(@Nullable Object target) {
        if (target instanceof Set) {
            return "set";
        }
        if (target instanceof List) {
            return "list";
        }
        return "collection";
    }

    @Override
    protected Collection createCollection(@NotNull String tagName) {
        if (tagName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tagName", "com/intellij/util/xmlb/CollectionBinding", "createCollection"));
        }
        return tagName.equals("set") ? new HashSet() : super.createCollection(tagName);
    }
}

