/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.engine.support.descriptor;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Objects;
import java.util.Optional;
import org.junit.platform.commons.JUnitException;
import org.junit.platform.commons.meta.API;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.ToStringBuilder;
import org.junit.platform.engine.support.descriptor.FilePosition;
import org.junit.platform.engine.support.descriptor.FileSystemSource;

@API(value=API.Usage.Experimental)
public class FileSource
implements FileSystemSource {
    private static final long serialVersionUID = 1L;
    private final File file;
    private final FilePosition filePosition;

    public FileSource(File file) {
        this(file, null);
    }

    public FileSource(File file, FilePosition filePosition) {
        Preconditions.notNull((Object)file, (String)"file must not be null");
        try {
            this.file = file.getCanonicalFile();
        }
        catch (IOException ex) {
            throw new JUnitException("Failed to retrieve canonical path for file: " + file, (Throwable)ex);
        }
        this.filePosition = filePosition;
    }

    @Override
    public final URI getUri() {
        return this.getFile().toURI();
    }

    @Override
    public final File getFile() {
        return this.file;
    }

    public final Optional<FilePosition> getPosition() {
        return Optional.ofNullable(this.filePosition);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileSource that = (FileSource)o;
        return Objects.equals(this.file, that.file) && Objects.equals(this.filePosition, that.filePosition);
    }

    public int hashCode() {
        return Objects.hash(this.file, this.filePosition);
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("file", (Object)this.file.toString()).append("filePosition", (Object)this.filePosition).toString();
    }
}

