/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.transcoder.image;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.batik.ext.awt.image.spi.ImageWriterParams;
import org.apache.batik.ext.awt.image.spi.ImageWriterRegistry;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.TranscodingHints;
import org.apache.batik.transcoder.image.ImageTranscoder;
import org.apache.batik.transcoder.image.resources.Messages;

public class JPEGTranscoder
extends ImageTranscoder {
    public static final TranscodingHints.Key KEY_QUALITY = new QualityKey();

    public JPEGTranscoder() {
        this.hints.put(ImageTranscoder.KEY_BACKGROUND_COLOR, Color.white);
    }

    @Override
    public BufferedImage createImage(int n, int n2) {
        return new BufferedImage(n, n2, 1);
    }

    @Override
    public void writeImage(BufferedImage bufferedImage, TranscoderOutput transcoderOutput) throws TranscoderException {
        OutputStream outputStream = transcoderOutput.getOutputStream();
        if ((outputStream = new OutputStreamWrapper(outputStream)) == null) {
            throw new TranscoderException(Messages.formatMessage("jpeg.badoutput", null));
        }
        try {
            Object object;
            float f;
            if (this.hints.containsKey(KEY_QUALITY)) {
                f = ((Float)this.hints.get(KEY_QUALITY)).floatValue();
            } else {
                object = new TranscoderException(Messages.formatMessage("jpeg.unspecifiedQuality", null));
                this.handler.error((TranscoderException)object);
                f = 0.75f;
            }
            object = ImageWriterRegistry.getInstance().getWriterFor("image/jpeg");
            ImageWriterParams imageWriterParams = new ImageWriterParams();
            imageWriterParams.setJPEGQuality(f, true);
            float f2 = this.userAgent.getPixelUnitToMillimeter();
            int n = (int)(25.4 / (double)f2 + 0.5);
            imageWriterParams.setResolution(n);
            object.writeImage(bufferedImage, outputStream, imageWriterParams);
            outputStream.flush();
        }
        catch (IOException iOException) {
            throw new TranscoderException(iOException);
        }
    }

    private static class OutputStreamWrapper
    extends OutputStream {
        OutputStream os;

        OutputStreamWrapper(OutputStream outputStream) {
            this.os = outputStream;
        }

        @Override
        public void close() throws IOException {
            if (this.os == null) {
                return;
            }
            try {
                this.os.close();
            }
            catch (IOException iOException) {
                this.os = null;
            }
        }

        @Override
        public void flush() throws IOException {
            if (this.os == null) {
                return;
            }
            try {
                this.os.flush();
            }
            catch (IOException iOException) {
                this.os = null;
            }
        }

        @Override
        public void write(byte[] byArray) throws IOException {
            if (this.os == null) {
                return;
            }
            try {
                this.os.write(byArray);
            }
            catch (IOException iOException) {
                this.os = null;
            }
        }

        @Override
        public void write(byte[] byArray, int n, int n2) throws IOException {
            if (this.os == null) {
                return;
            }
            try {
                this.os.write(byArray, n, n2);
            }
            catch (IOException iOException) {
                this.os = null;
            }
        }

        @Override
        public void write(int n) throws IOException {
            if (this.os == null) {
                return;
            }
            try {
                this.os.write(n);
            }
            catch (IOException iOException) {
                this.os = null;
            }
        }
    }

    private static class QualityKey
    extends TranscodingHints.Key {
        private QualityKey() {
        }

        @Override
        public boolean isCompatibleValue(Object object) {
            if (object instanceof Float) {
                float f = ((Float)object).floatValue();
                return f > 0.0f && f <= 1.0f;
            }
            return false;
        }
    }
}

