/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.psi;

import gnu.trove.TIntHashSet;
import org.jetbrains.annotations.NotNull;

public class PropertiesResourceBundleUtil {
    private static final TIntHashSet SYMBOLS_TO_ESCAPE = new TIntHashSet(new int[]{61, 58});
    private static final char ESCAPE_SYMBOL = '\\';

    @NotNull
    public static String fromPropertyValueToValueEditor(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/lang/properties/psi/PropertiesResourceBundleUtil", "fromPropertyValueToValueEditor"));
        }
        StringBuilder buffer = new StringBuilder();
        boolean escaped = false;
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c == '\\' && !escaped && (i == text.length() - 1 || text.charAt(i + 1) != 'u' && text.charAt(i + 1) != 'U')) {
                escaped = true;
                continue;
            }
            if (escaped && c == 'n') {
                buffer.append('\\');
            }
            buffer.append(c);
            escaped = false;
        }
        String string = buffer.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/psi/PropertiesResourceBundleUtil", "fromPropertyValueToValueEditor"));
        }
        return string;
    }

    @NotNull
    public static String fromValueEditorToPropertyValue(@NotNull String text, char delimiter) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/lang/properties/psi/PropertiesResourceBundleUtil", "fromValueEditorToPropertyValue"));
        }
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (i == 0 && (c == ' ' || c == '\t') || c == '\n' || delimiter == ' ' && SYMBOLS_TO_ESCAPE.contains((int)c)) {
                buffer.append('\\');
            } else if (c == '\\') {
                if (text.length() > i + 1) {
                    char nextChar = text.charAt(i + 1);
                    if (nextChar != 'n' && nextChar != 'u' && nextChar != 'U') {
                        buffer.append('\\');
                    }
                } else {
                    buffer.append('\\');
                }
            }
            buffer.append(c);
        }
        String string = buffer.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/psi/PropertiesResourceBundleUtil", "fromValueEditorToPropertyValue"));
        }
        return string;
    }
}

