/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.project.MavenIgnoredFilesConfigurable;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.project.ProjectBundle;
import org.jetbrains.idea.maven.utils.actions.MavenAction;
import org.jetbrains.idea.maven.utils.actions.MavenActionUtil;

public class ToggleIgnoredProjectsAction
extends MavenAction {
    @Override
    public void update(AnActionEvent e) {
        super.update(e);
        if (!this.isAvailable(e)) {
            return;
        }
        DataContext context = e.getDataContext();
        MavenProjectsManager projectsManager = MavenActionUtil.getProjectsManager(context);
        if (projectsManager == null) {
            return;
        }
        List<MavenProject> projects = MavenActionUtil.getMavenProjects(context);
        if (ToggleIgnoredProjectsAction.isIgnoredInSettings(projectsManager, projects)) {
            e.getPresentation().setText(ProjectBundle.message("maven.ignore.edit", new Object[0]));
        } else if (ToggleIgnoredProjectsAction.isIgnored(projectsManager, projects)) {
            e.getPresentation().setText(ProjectBundle.message("maven.unignore", new Object[0]));
        } else {
            e.getPresentation().setText(ProjectBundle.message("maven.ignore", new Object[0]));
        }
    }

    @Override
    protected boolean isAvailable(AnActionEvent e) {
        if (!super.isAvailable(e)) {
            return false;
        }
        DataContext context = e.getDataContext();
        MavenProjectsManager projectsManager = MavenActionUtil.getProjectsManager(context);
        if (projectsManager == null) {
            return false;
        }
        List<MavenProject> projects = MavenActionUtil.getMavenProjects(context);
        if (projects == null || projects.isEmpty()) {
            return false;
        }
        int ignoredStatesCount = 0;
        int ignoredCount = 0;
        for (MavenProject each : projects) {
            if (projectsManager.getIgnoredState(each)) {
                ++ignoredStatesCount;
            }
            if (!projectsManager.isIgnored(each)) continue;
            ++ignoredCount;
        }
        return !(ignoredCount != 0 && ignoredCount != projects.size() || ignoredStatesCount != 0 && ignoredStatesCount != projects.size());
    }

    private static boolean isIgnored(@NotNull MavenProjectsManager projectsManager, List<MavenProject> projects) {
        if (projectsManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectsManager", "org/jetbrains/idea/maven/project/actions/ToggleIgnoredProjectsAction", "isIgnored"));
        }
        return projectsManager.getIgnoredState(projects.get(0));
    }

    private static boolean isIgnoredInSettings(@NotNull MavenProjectsManager projectsManager, List<MavenProject> projects) {
        if (projectsManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectsManager", "org/jetbrains/idea/maven/project/actions/ToggleIgnoredProjectsAction", "isIgnoredInSettings"));
        }
        return projectsManager.isIgnored(projects.get(0)) && !ToggleIgnoredProjectsAction.isIgnored(projectsManager, projects);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/idea/maven/project/actions/ToggleIgnoredProjectsAction", "actionPerformed"));
        }
        DataContext context = e.getDataContext();
        MavenProjectsManager projectsManager = MavenActionUtil.getProjectsManager(context);
        if (projectsManager == null) {
            return;
        }
        List<MavenProject> projects = MavenActionUtil.getMavenProjects(context);
        Project project = MavenActionUtil.getProject(context);
        if (project == null) {
            return;
        }
        if (ToggleIgnoredProjectsAction.isIgnoredInSettings(projectsManager, projects)) {
            ShowSettingsUtil.getInstance().editConfigurable(project, (Configurable)new MavenIgnoredFilesConfigurable(project));
        } else {
            projectsManager.setIgnoredState(projects, !ToggleIgnoredProjectsAction.isIgnored(projectsManager, projects));
        }
    }
}

