/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.settingsRepository;

import com.intellij.configurationStore.ComponentStoreImpl;
import com.intellij.notification.Notification;
import com.intellij.notification.Notifications;
import com.intellij.notification.NotificationsAdapter;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationAdapter;
import com.intellij.openapi.application.ApplicationListener;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.application.impl.ApplicationImpl;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServiceKt;
import com.intellij.openapi.components.impl.stores.IComponentStore;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.util.messages.MessageBus;
import java.util.concurrent.Future;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.settingsRepository.AuthenticationException;
import org.jetbrains.settingsRepository.AutoSyncManager$sync$;
import org.jetbrains.settingsRepository.IcsManager;
import org.jetbrains.settingsRepository.IcsManagerKt;
import org.jetbrains.settingsRepository.NoRemoteRepositoryException;
import org.jetbrains.settingsRepository.RepositoryManager;
import org.jetbrains.settingsRepository.SyncKt;
import org.jetbrains.settingsRepository.UpdateResult;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\nJ\u000e\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\f\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010J\u0018\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\nH\u0002J\u000e\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u0016R\u0018\u0010\u0005\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00068\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/settingsRepository/AutoSyncManager;", "", "icsManager", "Lorg/jetbrains/settingsRepository/IcsManager;", "(Lorg/jetbrains/settingsRepository/IcsManager;)V", "autoSyncFuture", "Ljava/util/concurrent/Future;", "autoSync", "", "onAppExit", "", "force", "registerListeners", "application", "Lcom/intellij/openapi/application/Application;", "project", "Lcom/intellij/openapi/project/Project;", "sync", "app", "Lcom/intellij/openapi/application/impl/ApplicationImpl;", "waitAutoSync", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "settings-repository"})
public final class AutoSyncManager {
    private volatile Future<?> autoSyncFuture;
    private final IcsManager icsManager;

    public final void waitAutoSync(@NotNull ProgressIndicator indicator) {
        Intrinsics.checkParameterIsNotNull((Object)indicator, (String)"indicator");
        Future<?> autoFuture = this.autoSyncFuture;
        if (autoFuture != null) {
            if (autoFuture.isDone()) {
                this.autoSyncFuture = null;
            } else if (this.autoSyncFuture != null) {
                IcsManagerKt.getLOG().info("Wait for auto sync future");
                indicator.setText("Wait for auto sync completion");
                while (!autoFuture.isDone()) {
                    if (indicator.isCanceled()) {
                        return;
                    }
                    Thread.sleep(5L);
                }
            }
        }
    }

    public final void registerListeners(@NotNull Application application) {
        Intrinsics.checkParameterIsNotNull((Object)application, (String)"application");
        application.addApplicationListener((ApplicationListener)new ApplicationAdapter(this){
            final /* synthetic */ AutoSyncManager this$0;

            public void applicationExiting() {
                AutoSyncManager.autoSync$default(this.this$0, true, false, 2, null);
            }
            {
                this.this$0 = $outer;
            }
        });
    }

    public final void registerListeners(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        project.getMessageBus().connect().subscribe(Notifications.TOPIC, (Object)new NotificationsAdapter(this, project){
            final /* synthetic */ AutoSyncManager this$0;
            final /* synthetic */ Project $project;

            public void notify(@NotNull Notification notification) {
                String message;
                Intrinsics.checkParameterIsNotNull((Object)notification, (String)"notification");
                if (!AutoSyncManager.access$getIcsManager$p(this.this$0).getRepositoryActive() || this.$project.isDisposed()) {
                    return;
                }
                boolean bl = Intrinsics.areEqual((Object)notification.getGroupId(), (Object)VcsBalloonProblemNotifier.NOTIFICATION_GROUP.getDisplayId()) ? StringsKt.startsWith$default((String)(message = notification.getContent()), (String)"VCS Update Finished", (boolean)false, (int)2, null) || Intrinsics.areEqual((Object)message, (Object)VcsBundle.message((String)"message.text.file.is.up.to.date", (Object[])new Object[0])) || Intrinsics.areEqual((Object)message, (Object)VcsBundle.message((String)"message.text.all.files.are.up.to.date", (Object[])new Object[0])) : Intrinsics.areEqual((Object)notification.getGroupId(), (Object)VcsNotifier.NOTIFICATION_GROUP_ID.getDisplayId()) && Intrinsics.areEqual((Object)notification.getTitle(), (Object)"Push successful");
                if (bl) {
                    AutoSyncManager.autoSync$default(this.this$0, false, false, 3, null);
                }
            }
            {
                this.this$0 = $outer;
                this.$project = $captured_local_variable$1;
            }
        });
    }

    public final void autoSync(boolean onAppExit, boolean force) {
        Object future;
        if (!this.icsManager.getRepositoryActive() || !force && !this.icsManager.getSettings().getAutoSync()) {
            return;
        }
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = this.autoSyncFuture;
        if ((Future)future.element != null && !((Future)future.element).isDone()) {
            return;
        }
        ApplicationEx applicationEx = ApplicationManagerEx.getApplicationEx();
        if (applicationEx == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.application.impl.ApplicationImpl");
        }
        ApplicationImpl app = (ApplicationImpl)applicationEx;
        if (onAppExit) {
            this.sync(app, onAppExit);
            return;
        }
        if (app.isDisposeInProgress()) {
            return;
        }
        future.element = app.executeOnPooledThread(new Runnable(this, future, app, onAppExit){
            final /* synthetic */ AutoSyncManager this$0;
            final /* synthetic */ Ref.ObjectRef $future;
            final /* synthetic */ ApplicationImpl $app;
            final /* synthetic */ boolean $onAppExit;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void run() {
                if (Intrinsics.areEqual((Object)AutoSyncManager.access$getAutoSyncFuture$p(this.this$0), (Object)((Future)this.$future.element))) {
                    ShutDownTracker.getInstance().registerStopperThread(Thread.currentThread());
                    try {
                        AutoSyncManager.access$sync(this.this$0, this.$app, this.$onAppExit);
                    }
                    finally {
                        AutoSyncManager.access$setAutoSyncFuture$p(this.this$0, null);
                        ShutDownTracker.getInstance().unregisterStopperThread(Thread.currentThread());
                    }
                }
            }
            {
                this.this$0 = autoSyncManager;
                this.$future = objectRef;
                this.$app = applicationImpl;
                this.$onAppExit = bl;
            }
        });
        this.autoSyncFuture = (Future)future.element;
        future = null;
    }

    public static /* bridge */ /* synthetic */ void autoSync$default(AutoSyncManager autoSyncManager, boolean bl, boolean bl2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: autoSync");
        }
        if ((n & 1) != 0) {
            bl = false;
        }
        if ((n & 2) != 0) {
            bl2 = false;
        }
        autoSyncManager.autoSync(bl, bl2);
    }

    private final void sync(ApplicationImpl app, boolean onAppExit) {
        try {
            this.icsManager.runInAutoCommitDisabledMode((Function0<Unit>)((Function0)new Function0<Unit>(this, onAppExit, app){
                final /* synthetic */ AutoSyncManager this$0;
                final /* synthetic */ boolean $onAppExit$inlined;
                final /* synthetic */ ApplicationImpl $app$inlined;

                public final void invoke() {
                    RepositoryManager repositoryManager = AutoSyncManager.access$getIcsManager$p(this.this$0).getRepositoryManager();
                    if (!repositoryManager.canCommit()) {
                        IcsManagerKt.getLOG().warn("Auto sync skipped: repository is not committable");
                        return;
                    }
                    if (this.$onAppExit$inlined && !RepositoryManager.DefaultImpls.commit$default(repositoryManager, null, null, false, 7, null) && repositoryManager.getAheadCommitsCount() == 0) {
                        return;
                    }
                    RepositoryManager.Updater updater = RepositoryManager.DefaultImpls.fetch$default(repositoryManager, null, 1, null);
                    this.$app$inlined.invokeAndWait(new Runnable(this, updater){
                        final /* synthetic */ sync$$inlined$catchAndLog$lambda$1 this$0;
                        final /* synthetic */ RepositoryManager.Updater $updater;

                        public final void run() {
                            try {
                                UpdateResult updateResult = this.$updater.merge();
                                if (!this.this$0.$onAppExit$inlined && !this.this$0.$app$inlined.isDisposeInProgress() && updateResult != null) {
                                    IComponentStore iComponentStore = ServiceKt.getStateStore((ComponentManager)((ComponentManager)this.this$0.$app$inlined));
                                    if (iComponentStore == null) {
                                        throw new TypeCastException("null cannot be cast to non-null type com.intellij.configurationStore.ComponentStoreImpl");
                                    }
                                    ComponentStoreImpl componentStoreImpl = (ComponentStoreImpl)iComponentStore;
                                    MessageBus messageBus = this.this$0.$app$inlined.getMessageBus();
                                    Intrinsics.checkExpressionValueIsNotNull((Object)messageBus, (String)"app.messageBus");
                                    if (SyncKt.updateStoragesFromStreamProvider$default(componentStoreImpl, updateResult, messageBus, false, 8, null)) {
                                        this.this$0.$app$inlined.exit(true, true, true, true);
                                    }
                                }
                            }
                            catch (ProcessCanceledException e$iv) {
                            }
                            catch (Throwable e$iv) {
                                if (e$iv instanceof AuthenticationException || e$iv instanceof NoRemoteRepositoryException) {
                                    IcsManagerKt.getLOG().warn(e$iv);
                                }
                                IcsManagerKt.getLOG().error(e$iv);
                            }
                        }
                        {
                            this.this$0 = var1_1;
                            this.$updater = updater;
                        }
                    }, ModalityState.NON_MODAL);
                    if (!updater.getDefinitelySkipPush()) {
                        RepositoryManager.DefaultImpls.push$default(repositoryManager, null, 1, null);
                    }
                }
                {
                    this.this$0 = autoSyncManager;
                    this.$onAppExit$inlined = bl;
                    this.$app$inlined = applicationImpl;
                    super(0);
                }
            }));
        }
        catch (ProcessCanceledException e$iv) {
        }
        catch (Throwable e$iv) {
            if (e$iv instanceof AuthenticationException || e$iv instanceof NoRemoteRepositoryException) {
                IcsManagerKt.getLOG().warn(e$iv);
            }
            IcsManagerKt.getLOG().error(e$iv);
        }
    }

    public AutoSyncManager(@NotNull IcsManager icsManager2) {
        Intrinsics.checkParameterIsNotNull((Object)icsManager2, (String)"icsManager");
        this.icsManager = icsManager2;
    }

    @NotNull
    public static final /* synthetic */ IcsManager access$getIcsManager$p(AutoSyncManager $this) {
        return $this.icsManager;
    }

    @Nullable
    public static final /* synthetic */ Future access$getAutoSyncFuture$p(AutoSyncManager $this) {
        return $this.autoSyncFuture;
    }

    public static final /* synthetic */ void access$setAutoSyncFuture$p(AutoSyncManager $this, @Nullable Future future) {
        $this.autoSyncFuture = future;
    }

    public static final /* synthetic */ void access$sync(AutoSyncManager $this, @NotNull ApplicationImpl app, boolean onAppExit) {
        $this.sync(app, onAppExit);
    }
}

