/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager;

import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum AvdScaleFactor {
    TEN_TO_ONE(10, 1, "0.1"),
    FOUR_TO_ONE(4, 1, "0.25"),
    TWO_TO_ONE(2, 1, "0.5"),
    ONE_TO_ONE(1, 1, "1"),
    ONE_TO_TWO(1, 2, "2"),
    ONE_TO_THREE(1, 3, "3"),
    AUTO("Auto", "auto");

    @NotNull
    private final String myHumanReadableName;
    @NotNull
    private final String myValue;

    @Nullable
    public static AvdScaleFactor findByValue(@NotNull String value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/avdmanager/AvdScaleFactor", "findByValue"));
        }
        for (AvdScaleFactor factor : AvdScaleFactor.values()) {
            if (!value.equals(factor.getValue())) continue;
            return factor;
        }
        return null;
    }

    private AvdScaleFactor(@NotNull int deviceDp, int screenPixels, String value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/avdmanager/AvdScaleFactor", "<init>"));
        }
        this.myHumanReadableName = String.format(Locale.getDefault(), "%ddp on device = %dpx on screen", deviceDp, screenPixels);
        this.myValue = value;
    }

    private AvdScaleFactor(String humanReadableName, String value) {
        if (humanReadableName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "humanReadableName", "com/android/tools/idea/avdmanager/AvdScaleFactor", "<init>"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/avdmanager/AvdScaleFactor", "<init>"));
        }
        this.myHumanReadableName = humanReadableName;
        this.myValue = value;
    }

    @NotNull
    public String getValue() {
        String string = this.myValue;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/AvdScaleFactor", "getValue"));
        }
        return string;
    }

    public String toString() {
        return this.myHumanReadableName;
    }
}

